"""
This file is generated by the openapi-python-client tool via the generate_api_client.py script

It is a customized template from the openapi-python-client tool's default template:
https://github.com/openapi-generators/openapi-python-client/blob/861ef5622f10fc96d240dc9becb0edf94e61446c/openapi_python_client/templates/model.py.jinja

The main change is:
- Fix typing issues
"""

# flake8: noqa: C901

from enum import Enum
from typing import TYPE_CHECKING, Any, Dict, Type, TypeVar, Union, cast

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..models.embedding_finetuning_method import EmbeddingFinetuningMethod
from ..models.pretrained_embedding_model_name import PretrainedEmbeddingModelName
from ..types import UNSET, Unset

if TYPE_CHECKING:
    from ..models.finetune_embedding_model_request_training_args import FinetuneEmbeddingModelRequestTrainingArgs


T = TypeVar("T", bound="FinetuneEmbeddingModelRequest")


@_attrs_define
class FinetuneEmbeddingModelRequest:
    """
    Attributes:
        name (str):
        base_model (PretrainedEmbeddingModelName): Names of pretrained embedding models that are supported by OrcaCloud
        train_memoryset_id (Union[None, Unset, str]):
        train_memoryset_name (Union[None, Unset, str]):
        train_datasource_id (Union[None, Unset, str]):
        train_datasource_name (Union[None, Unset, str]):
        eval_datasource_id (Union[None, Unset, str]):
        eval_datasource_name (Union[None, Unset, str]):
        label_column (Union[Unset, str]):  Default: 'label'.
        value_column (Union[Unset, str]):  Default: 'value'.
        training_method (Union[Unset, EmbeddingFinetuningMethod]):
        training_args (Union[Unset, FinetuneEmbeddingModelRequestTrainingArgs]):
    """

    name: str
    base_model: PretrainedEmbeddingModelName
    train_memoryset_id: Union[None, Unset, str] = UNSET
    train_memoryset_name: Union[None, Unset, str] = UNSET
    train_datasource_id: Union[None, Unset, str] = UNSET
    train_datasource_name: Union[None, Unset, str] = UNSET
    eval_datasource_id: Union[None, Unset, str] = UNSET
    eval_datasource_name: Union[None, Unset, str] = UNSET
    label_column: Union[Unset, str] = "label"
    value_column: Union[Unset, str] = "value"
    training_method: Union[Unset, EmbeddingFinetuningMethod] = UNSET
    training_args: Union[Unset, "FinetuneEmbeddingModelRequestTrainingArgs"] = UNSET
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        name = self.name

        base_model = self.base_model.value if isinstance(self.base_model, Enum) else self.base_model

        train_memoryset_id: Union[None, Unset, str]
        if isinstance(self.train_memoryset_id, Unset):
            train_memoryset_id = UNSET
        else:
            train_memoryset_id = self.train_memoryset_id

        train_memoryset_name: Union[None, Unset, str]
        if isinstance(self.train_memoryset_name, Unset):
            train_memoryset_name = UNSET
        else:
            train_memoryset_name = self.train_memoryset_name

        train_datasource_id: Union[None, Unset, str]
        if isinstance(self.train_datasource_id, Unset):
            train_datasource_id = UNSET
        else:
            train_datasource_id = self.train_datasource_id

        train_datasource_name: Union[None, Unset, str]
        if isinstance(self.train_datasource_name, Unset):
            train_datasource_name = UNSET
        else:
            train_datasource_name = self.train_datasource_name

        eval_datasource_id: Union[None, Unset, str]
        if isinstance(self.eval_datasource_id, Unset):
            eval_datasource_id = UNSET
        else:
            eval_datasource_id = self.eval_datasource_id

        eval_datasource_name: Union[None, Unset, str]
        if isinstance(self.eval_datasource_name, Unset):
            eval_datasource_name = UNSET
        else:
            eval_datasource_name = self.eval_datasource_name

        label_column = self.label_column

        value_column = self.value_column

        training_method: Union[Unset, str] = UNSET
        if not isinstance(self.training_method, Unset):
            training_method = self.training_method.value

        training_args: Union[Unset, Dict[str, Any]] = UNSET
        if not isinstance(self.training_args, Unset):
            training_args = self.training_args.to_dict()

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "name": name,
                "base_model": base_model,
            }
        )
        if train_memoryset_id is not UNSET:
            field_dict["train_memoryset_id"] = train_memoryset_id
        if train_memoryset_name is not UNSET:
            field_dict["train_memoryset_name"] = train_memoryset_name
        if train_datasource_id is not UNSET:
            field_dict["train_datasource_id"] = train_datasource_id
        if train_datasource_name is not UNSET:
            field_dict["train_datasource_name"] = train_datasource_name
        if eval_datasource_id is not UNSET:
            field_dict["eval_datasource_id"] = eval_datasource_id
        if eval_datasource_name is not UNSET:
            field_dict["eval_datasource_name"] = eval_datasource_name
        if label_column is not UNSET:
            field_dict["label_column"] = label_column
        if value_column is not UNSET:
            field_dict["value_column"] = value_column
        if training_method is not UNSET:
            field_dict["training_method"] = training_method
        if training_args is not UNSET:
            field_dict["training_args"] = training_args

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: dict[str, Any]) -> T:
        from ..models.finetune_embedding_model_request_training_args import FinetuneEmbeddingModelRequestTrainingArgs

        d = src_dict.copy()
        name = d.pop("name")

        base_model = PretrainedEmbeddingModelName(d.pop("base_model"))

        def _parse_train_memoryset_id(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        train_memoryset_id = _parse_train_memoryset_id(d.pop("train_memoryset_id", UNSET))

        def _parse_train_memoryset_name(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        train_memoryset_name = _parse_train_memoryset_name(d.pop("train_memoryset_name", UNSET))

        def _parse_train_datasource_id(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        train_datasource_id = _parse_train_datasource_id(d.pop("train_datasource_id", UNSET))

        def _parse_train_datasource_name(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        train_datasource_name = _parse_train_datasource_name(d.pop("train_datasource_name", UNSET))

        def _parse_eval_datasource_id(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        eval_datasource_id = _parse_eval_datasource_id(d.pop("eval_datasource_id", UNSET))

        def _parse_eval_datasource_name(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        eval_datasource_name = _parse_eval_datasource_name(d.pop("eval_datasource_name", UNSET))

        label_column = d.pop("label_column", UNSET)

        value_column = d.pop("value_column", UNSET)

        _training_method = d.pop("training_method", UNSET)
        training_method: Union[Unset, EmbeddingFinetuningMethod]
        if isinstance(_training_method, Unset):
            training_method = UNSET
        else:
            training_method = EmbeddingFinetuningMethod(_training_method)

        _training_args = d.pop("training_args", UNSET)
        training_args: Union[Unset, FinetuneEmbeddingModelRequestTrainingArgs]
        if isinstance(_training_args, Unset):
            training_args = UNSET
        else:
            training_args = FinetuneEmbeddingModelRequestTrainingArgs.from_dict(_training_args)

        finetune_embedding_model_request = cls(
            name=name,
            base_model=base_model,
            train_memoryset_id=train_memoryset_id,
            train_memoryset_name=train_memoryset_name,
            train_datasource_id=train_datasource_id,
            train_datasource_name=train_datasource_name,
            eval_datasource_id=eval_datasource_id,
            eval_datasource_name=eval_datasource_name,
            label_column=label_column,
            value_column=value_column,
            training_method=training_method,
            training_args=training_args,
        )

        finetune_embedding_model_request.additional_properties = d
        return finetune_embedding_model_request

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
