"""
This file is generated by the openapi-python-client tool via the generate_api_client.py script

It is a customized template from the openapi-python-client tool's default template:
https://github.com/openapi-generators/openapi-python-client/blob/861ef5622f10fc96d240dc9becb0edf94e61446c/openapi_python_client/templates/model.py.jinja

The main change is:
- Fix typing issues
"""

# flake8: noqa: C901

import datetime
from enum import Enum
from typing import TYPE_CHECKING, Any, Dict, Type, TypeVar, Union, cast

from attrs import define as _attrs_define
from attrs import field as _attrs_field
from dateutil.parser import isoparse

from ..models.task_status import TaskStatus

if TYPE_CHECKING:
    from ..models.classification_evaluation_result import ClassificationEvaluationResult


T = TypeVar("T", bound="EvaluationResponse")


@_attrs_define
class EvaluationResponse:
    """
    Attributes:
        task_id (str):
        org_id (str):
        status (TaskStatus): Status of task in the task queue
        result (Union['ClassificationEvaluationResult', None]):
        created_at (datetime.datetime):
        updated_at (datetime.datetime):
    """

    task_id: str
    org_id: str
    status: TaskStatus
    result: Union["ClassificationEvaluationResult", None]
    created_at: datetime.datetime
    updated_at: datetime.datetime
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        from ..models.classification_evaluation_result import ClassificationEvaluationResult

        task_id = self.task_id

        org_id = self.org_id

        status = self.status.value if isinstance(self.status, Enum) else self.status

        result: Union[Dict[str, Any], None]
        if isinstance(self.result, ClassificationEvaluationResult):
            result = self.result.to_dict()
        else:
            result = self.result

        created_at = self.created_at.isoformat()

        updated_at = self.updated_at.isoformat()

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "task_id": task_id,
                "org_id": org_id,
                "status": status,
                "result": result,
                "created_at": created_at,
                "updated_at": updated_at,
            }
        )

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: dict[str, Any]) -> T:
        from ..models.classification_evaluation_result import ClassificationEvaluationResult

        d = src_dict.copy()
        task_id = d.pop("task_id")

        org_id = d.pop("org_id")

        status = TaskStatus(d.pop("status"))

        def _parse_result(data: object) -> Union["ClassificationEvaluationResult", None]:
            if data is None:
                return data
            try:
                if not isinstance(data, dict):
                    raise TypeError()
                result_type_0 = ClassificationEvaluationResult.from_dict(data)

                return result_type_0
            except:  # noqa: E722
                pass
            return cast(Union["ClassificationEvaluationResult", None], data)

        result = _parse_result(d.pop("result"))

        created_at = isoparse(d.pop("created_at"))

        updated_at = isoparse(d.pop("updated_at"))

        evaluation_response = cls(
            task_id=task_id,
            org_id=org_id,
            status=status,
            result=result,
            created_at=created_at,
            updated_at=updated_at,
        )

        evaluation_response.additional_properties = d
        return evaluation_response

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
