"""
This file is generated by the openapi-python-client tool via the generate_api_client.py script

It is a customized template from the openapi-python-client tool's default template:
https://github.com/openapi-generators/openapi-python-client/blob/861ef5622f10fc96d240dc9becb0edf94e61446c/openapi_python_client/templates/model.py.jinja

The main change is:
- Fix typing issues
"""

# flake8: noqa: C901

from typing import Any, List, Type, TypeVar, Union, cast

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..types import UNSET, Unset

T = TypeVar("T", bound="EvaluationRequest")


@_attrs_define
class EvaluationRequest:
    """
    Attributes:
        datasource_label_column (str):
        datasource_value_column (str):
        datasource_id (Union[None, Unset, str]):
        datasource_name (Union[None, Unset, str]):
        memoryset_override_id (Union[None, Unset, str]):
        record_telemetry (Union[Unset, bool]):  Default: False.
        telemetry_tags (Union[List[str], None, Unset]):
    """

    datasource_label_column: str
    datasource_value_column: str
    datasource_id: Union[None, Unset, str] = UNSET
    datasource_name: Union[None, Unset, str] = UNSET
    memoryset_override_id: Union[None, Unset, str] = UNSET
    record_telemetry: Union[Unset, bool] = False
    telemetry_tags: Union[List[str], None, Unset] = UNSET
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        datasource_label_column = self.datasource_label_column

        datasource_value_column = self.datasource_value_column

        datasource_id: Union[None, Unset, str]
        if isinstance(self.datasource_id, Unset):
            datasource_id = UNSET
        else:
            datasource_id = self.datasource_id

        datasource_name: Union[None, Unset, str]
        if isinstance(self.datasource_name, Unset):
            datasource_name = UNSET
        else:
            datasource_name = self.datasource_name

        memoryset_override_id: Union[None, Unset, str]
        if isinstance(self.memoryset_override_id, Unset):
            memoryset_override_id = UNSET
        else:
            memoryset_override_id = self.memoryset_override_id

        record_telemetry = self.record_telemetry

        telemetry_tags: Union[List[str], None, Unset]
        if isinstance(self.telemetry_tags, Unset):
            telemetry_tags = UNSET
        elif isinstance(self.telemetry_tags, list):
            telemetry_tags = self.telemetry_tags

        else:
            telemetry_tags = self.telemetry_tags

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "datasource_label_column": datasource_label_column,
                "datasource_value_column": datasource_value_column,
            }
        )
        if datasource_id is not UNSET:
            field_dict["datasource_id"] = datasource_id
        if datasource_name is not UNSET:
            field_dict["datasource_name"] = datasource_name
        if memoryset_override_id is not UNSET:
            field_dict["memoryset_override_id"] = memoryset_override_id
        if record_telemetry is not UNSET:
            field_dict["record_telemetry"] = record_telemetry
        if telemetry_tags is not UNSET:
            field_dict["telemetry_tags"] = telemetry_tags

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: dict[str, Any]) -> T:
        d = src_dict.copy()
        datasource_label_column = d.pop("datasource_label_column")

        datasource_value_column = d.pop("datasource_value_column")

        def _parse_datasource_id(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        datasource_id = _parse_datasource_id(d.pop("datasource_id", UNSET))

        def _parse_datasource_name(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        datasource_name = _parse_datasource_name(d.pop("datasource_name", UNSET))

        def _parse_memoryset_override_id(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        memoryset_override_id = _parse_memoryset_override_id(d.pop("memoryset_override_id", UNSET))

        record_telemetry = d.pop("record_telemetry", UNSET)

        def _parse_telemetry_tags(data: object) -> Union[List[str], None, Unset]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            try:
                if not isinstance(data, list):
                    raise TypeError()
                telemetry_tags_type_0 = cast(List[str], data)

                return telemetry_tags_type_0
            except:  # noqa: E722
                pass
            return cast(Union[List[str], None, Unset], data)

        telemetry_tags = _parse_telemetry_tags(d.pop("telemetry_tags", UNSET))

        evaluation_request = cls(
            datasource_label_column=datasource_label_column,
            datasource_value_column=datasource_value_column,
            datasource_id=datasource_id,
            datasource_name=datasource_name,
            memoryset_override_id=memoryset_override_id,
            record_telemetry=record_telemetry,
            telemetry_tags=telemetry_tags,
        )

        evaluation_request.additional_properties = d
        return evaluation_request

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
