"""
This file is generated by the openapi-python-client tool via the generate_api_client.py script

It is a customized template from the openapi-python-client tool's default template:
https://github.com/openapi-generators/openapi-python-client/blob/861ef5622f10fc96d240dc9becb0edf94e61446c/openapi_python_client/templates/model.py.jinja

The main change is:
- Fix typing issues
"""

# flake8: noqa: C901

from typing import TYPE_CHECKING, Any, Type, TypeVar, Union, cast

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..types import UNSET, Unset

if TYPE_CHECKING:
    from ..models.analyze_neighbor_labels_result import AnalyzeNeighborLabelsResult


T = TypeVar("T", bound="EmbeddingModelResult")


@_attrs_define
class EmbeddingModelResult:
    """
    Attributes:
        embedding_model_name (str):
        embedding_model_path (str):
        analysis_result (AnalyzeNeighborLabelsResult):
        memoryset_name (Union[None, Unset, str]):
    """

    embedding_model_name: str
    embedding_model_path: str
    analysis_result: "AnalyzeNeighborLabelsResult"
    memoryset_name: Union[None, Unset, str] = UNSET
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        embedding_model_name = self.embedding_model_name

        embedding_model_path = self.embedding_model_path

        analysis_result = self.analysis_result.to_dict()

        memoryset_name: Union[None, Unset, str]
        if isinstance(self.memoryset_name, Unset):
            memoryset_name = UNSET
        else:
            memoryset_name = self.memoryset_name

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "embedding_model_name": embedding_model_name,
                "embedding_model_path": embedding_model_path,
                "analysis_result": analysis_result,
            }
        )
        if memoryset_name is not UNSET:
            field_dict["memoryset_name"] = memoryset_name

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: dict[str, Any]) -> T:
        from ..models.analyze_neighbor_labels_result import AnalyzeNeighborLabelsResult

        d = src_dict.copy()
        embedding_model_name = d.pop("embedding_model_name")

        embedding_model_path = d.pop("embedding_model_path")

        analysis_result = AnalyzeNeighborLabelsResult.from_dict(d.pop("analysis_result"))

        def _parse_memoryset_name(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        memoryset_name = _parse_memoryset_name(d.pop("memoryset_name", UNSET))

        embedding_model_result = cls(
            embedding_model_name=embedding_model_name,
            embedding_model_path=embedding_model_path,
            analysis_result=analysis_result,
            memoryset_name=memoryset_name,
        )

        embedding_model_result.additional_properties = d
        return embedding_model_result

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
