"""
This file is generated by the openapi-python-client tool via the generate_api_client.py script

It is a customized template from the openapi-python-client tool's default template:
https://github.com/openapi-generators/openapi-python-client/blob/861ef5622f10fc96d240dc9becb0edf94e61446c/openapi_python_client/templates/model.py.jinja

The main change is:
- Fix typing issues
"""

# flake8: noqa: C901

from typing import TYPE_CHECKING, Any, Dict, List, Type, TypeVar, Union

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..types import UNSET, Unset

if TYPE_CHECKING:
    from ..models.embedding_model_result import EmbeddingModelResult


T = TypeVar("T", bound="EmbeddingEvaluationResult")


@_attrs_define
class EmbeddingEvaluationResult:
    """
    Attributes:
        evaluation_results (Union[Unset, List['EmbeddingModelResult']]):
    """

    evaluation_results: Union[Unset, List["EmbeddingModelResult"]] = UNSET
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        evaluation_results: Union[Unset, List[Dict[str, Any]]] = UNSET
        if not isinstance(self.evaluation_results, Unset):
            evaluation_results = []
            for evaluation_results_item_data in self.evaluation_results:
                evaluation_results_item = evaluation_results_item_data.to_dict()
                evaluation_results.append(evaluation_results_item)

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({})
        if evaluation_results is not UNSET:
            field_dict["evaluation_results"] = evaluation_results

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: dict[str, Any]) -> T:
        from ..models.embedding_model_result import EmbeddingModelResult

        d = src_dict.copy()
        evaluation_results = []
        _evaluation_results = d.pop("evaluation_results", UNSET)
        for evaluation_results_item_data in _evaluation_results or []:
            evaluation_results_item = EmbeddingModelResult.from_dict(evaluation_results_item_data)

            evaluation_results.append(evaluation_results_item)

        embedding_evaluation_result = cls(
            evaluation_results=evaluation_results,
        )

        embedding_evaluation_result.additional_properties = d
        return embedding_evaluation_result

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
