"""
This file is generated by the openapi-python-client tool via the generate_api_client.py script

It is a customized template from the openapi-python-client tool's default template:
https://github.com/openapi-generators/openapi-python-client/blob/861ef5622f10fc96d240dc9becb0edf94e61446c/openapi_python_client/templates/model.py.jinja

The main change is:
- Fix typing issues
"""

# flake8: noqa: C901

from enum import Enum
from typing import Any, List, Type, TypeVar, Union, cast

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..models.pretrained_embedding_model_name import PretrainedEmbeddingModelName
from ..types import UNSET, Unset

T = TypeVar("T", bound="EmbeddingEvaluationRequest")


@_attrs_define
class EmbeddingEvaluationRequest:
    """
    Attributes:
        value_column (str):
        label_column (str):
        source_id_column (Union[None, str]):
        neighbor_count (Union[Unset, int]):  Default: 5.
        label_names (Union[List[str], None, Unset]):
        embedding_models (Union[List[PretrainedEmbeddingModelName], None, Unset]):
    """

    value_column: str
    label_column: str
    source_id_column: Union[None, str]
    neighbor_count: Union[Unset, int] = 5
    label_names: Union[List[str], None, Unset] = UNSET
    embedding_models: Union[List[PretrainedEmbeddingModelName], None, Unset] = UNSET
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        value_column = self.value_column

        label_column = self.label_column

        source_id_column: Union[None, str]
        source_id_column = self.source_id_column

        neighbor_count = self.neighbor_count

        label_names: Union[List[str], None, Unset]
        if isinstance(self.label_names, Unset):
            label_names = UNSET
        elif isinstance(self.label_names, list):
            label_names = self.label_names

        else:
            label_names = self.label_names

        embedding_models: Union[List[str], None, Unset]
        if isinstance(self.embedding_models, Unset):
            embedding_models = UNSET
        elif isinstance(self.embedding_models, list):
            embedding_models = []
            for embedding_models_type_0_item_data in self.embedding_models:
                embedding_models_type_0_item = (
                    embedding_models_type_0_item_data.value
                    if isinstance(embedding_models_type_0_item_data, Enum)
                    else embedding_models_type_0_item_data
                )
                embedding_models.append(embedding_models_type_0_item)

        else:
            embedding_models = self.embedding_models

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "value_column": value_column,
                "label_column": label_column,
                "source_id_column": source_id_column,
            }
        )
        if neighbor_count is not UNSET:
            field_dict["neighbor_count"] = neighbor_count
        if label_names is not UNSET:
            field_dict["label_names"] = label_names
        if embedding_models is not UNSET:
            field_dict["embedding_models"] = embedding_models

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: dict[str, Any]) -> T:
        d = src_dict.copy()
        value_column = d.pop("value_column")

        label_column = d.pop("label_column")

        def _parse_source_id_column(data: object) -> Union[None, str]:
            if data is None:
                return data
            return cast(Union[None, str], data)

        source_id_column = _parse_source_id_column(d.pop("source_id_column"))

        neighbor_count = d.pop("neighbor_count", UNSET)

        def _parse_label_names(data: object) -> Union[List[str], None, Unset]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            try:
                if not isinstance(data, list):
                    raise TypeError()
                label_names_type_0 = cast(List[str], data)

                return label_names_type_0
            except:  # noqa: E722
                pass
            return cast(Union[List[str], None, Unset], data)

        label_names = _parse_label_names(d.pop("label_names", UNSET))

        def _parse_embedding_models(data: object) -> Union[List[PretrainedEmbeddingModelName], None, Unset]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            try:
                if not isinstance(data, list):
                    raise TypeError()
                embedding_models_type_0 = []
                _embedding_models_type_0 = data
                for embedding_models_type_0_item_data in _embedding_models_type_0:
                    embedding_models_type_0_item = PretrainedEmbeddingModelName(embedding_models_type_0_item_data)

                    embedding_models_type_0.append(embedding_models_type_0_item)

                return embedding_models_type_0
            except:  # noqa: E722
                pass
            return cast(Union[List[PretrainedEmbeddingModelName], None, Unset], data)

        embedding_models = _parse_embedding_models(d.pop("embedding_models", UNSET))

        embedding_evaluation_request = cls(
            value_column=value_column,
            label_column=label_column,
            source_id_column=source_id_column,
            neighbor_count=neighbor_count,
            label_names=label_names,
            embedding_models=embedding_models,
        )

        embedding_evaluation_request.additional_properties = d
        return embedding_evaluation_request

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
