"""
This file is generated by the openapi-python-client tool via the generate_api_client.py script

It is a customized template from the openapi-python-client tool's default template:
https://github.com/openapi-generators/openapi-python-client/blob/861ef5622f10fc96d240dc9becb0edf94e61446c/openapi_python_client/templates/model.py.jinja

The main change is:
- Fix typing issues
"""

# flake8: noqa: C901

from typing import Any, List, Type, TypeVar, Union, cast

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..types import UNSET, Unset

T = TypeVar("T", bound="EmbedRequest")


@_attrs_define
class EmbedRequest:
    """
    Attributes:
        values (List[str]):
        max_seq_length (Union[None, Unset, int]):
    """

    values: List[str]
    max_seq_length: Union[None, Unset, int] = UNSET
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        values: List[str]
        if isinstance(self.values, list):
            values = self.values

        max_seq_length: Union[None, Unset, int]
        if isinstance(self.max_seq_length, Unset):
            max_seq_length = UNSET
        else:
            max_seq_length = self.max_seq_length

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "values": values,
            }
        )
        if max_seq_length is not UNSET:
            field_dict["max_seq_length"] = max_seq_length

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: dict[str, Any]) -> T:
        d = src_dict.copy()

        def _parse_values(data: object) -> List[str]:
            try:
                if not isinstance(data, list):
                    raise TypeError()
                values_type_0 = cast(List[str], data)

                return values_type_0
            except:  # noqa: E722
                pass
            try:
                if not isinstance(data, list):
                    raise TypeError()
                values_type_1 = cast(List[str], data)

                return values_type_1
            except:  # noqa: E722
                pass
            try:
                if not isinstance(data, list):
                    raise TypeError()
                values_type_2 = cast(List[str], data)

                return values_type_2
            except:  # noqa: E722
                pass
            if not isinstance(data, list):
                raise TypeError()
            values_type_3 = []
            _values_type_3 = data
            for values_type_3_item_data in _values_type_3:

                def _parse_values_type_3_item(data: object) -> str:
                    return cast(str, data)

                values_type_3_item = _parse_values_type_3_item(values_type_3_item_data)

                values_type_3.append(values_type_3_item)

            return values_type_3

        values = _parse_values(d.pop("values"))

        def _parse_max_seq_length(data: object) -> Union[None, Unset, int]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, int], data)

        max_seq_length = _parse_max_seq_length(d.pop("max_seq_length", UNSET))

        embed_request = cls(
            values=values,
            max_seq_length=max_seq_length,
        )

        embed_request.additional_properties = d
        return embed_request

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
