"""
This file is generated by the openapi-python-client tool via the generate_api_client.py script

It is a customized template from the openapi-python-client tool's default template:
https://github.com/openapi-generators/openapi-python-client/blob/861ef5622f10fc96d240dc9becb0edf94e61446c/openapi_python_client/templates/model.py.jinja

The main change is:
- Fix typing issues
"""

# flake8: noqa: C901

import datetime
from typing import TYPE_CHECKING, Any, List, Type, TypeVar, Union, cast

from attrs import define as _attrs_define
from attrs import field as _attrs_field
from dateutil.parser import isoparse

if TYPE_CHECKING:
    from ..models.column_info import ColumnInfo


T = TypeVar("T", bound="DatasourceMetadata")


@_attrs_define
class DatasourceMetadata:
    """
    Attributes:
        id (str):
        org_id (str):
        name (str):
        description (Union[None, str]):
        storage_path (str):
        length (int):
        columns (List['ColumnInfo']):
        created_at (datetime.datetime):
        updated_at (datetime.datetime):
    """

    id: str
    org_id: str
    name: str
    description: Union[None, str]
    storage_path: str
    length: int
    columns: List["ColumnInfo"]
    created_at: datetime.datetime
    updated_at: datetime.datetime
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        id = self.id

        org_id = self.org_id

        name = self.name

        description: Union[None, str]
        description = self.description

        storage_path = self.storage_path

        length = self.length

        columns = []
        for columns_item_data in self.columns:
            columns_item = columns_item_data.to_dict()
            columns.append(columns_item)

        created_at = self.created_at.isoformat()

        updated_at = self.updated_at.isoformat()

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "id": id,
                "org_id": org_id,
                "name": name,
                "description": description,
                "storage_path": storage_path,
                "length": length,
                "columns": columns,
                "created_at": created_at,
                "updated_at": updated_at,
            }
        )

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: dict[str, Any]) -> T:
        from ..models.column_info import ColumnInfo

        d = src_dict.copy()
        id = d.pop("id")

        org_id = d.pop("org_id")

        name = d.pop("name")

        def _parse_description(data: object) -> Union[None, str]:
            if data is None:
                return data
            return cast(Union[None, str], data)

        description = _parse_description(d.pop("description"))

        storage_path = d.pop("storage_path")

        length = d.pop("length")

        columns = []
        _columns = d.pop("columns")
        for columns_item_data in _columns:
            columns_item = ColumnInfo.from_dict(columns_item_data)

            columns.append(columns_item)

        created_at = isoparse(d.pop("created_at"))

        updated_at = isoparse(d.pop("updated_at"))

        datasource_metadata = cls(
            id=id,
            org_id=org_id,
            name=name,
            description=description,
            storage_path=storage_path,
            length=length,
            columns=columns,
            created_at=created_at,
            updated_at=updated_at,
        )

        datasource_metadata.additional_properties = d
        return datasource_metadata

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
