"""
This file is generated by the openapi-python-client tool via the generate_api_client.py script

It is a customized template from the openapi-python-client tool's default template:
https://github.com/openapi-generators/openapi-python-client/blob/861ef5622f10fc96d240dc9becb0edf94e61446c/openapi_python_client/templates/model.py.jinja

The main change is:
- Fix typing issues
"""

# flake8: noqa: C901

from typing import Any, Type, TypeVar, Union, cast

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..models.rac_head_type import RACHeadType
from ..types import UNSET, Unset

T = TypeVar("T", bound="CreateRACModelRequest")


@_attrs_define
class CreateRACModelRequest:
    """
    Attributes:
        name (str):
        description (Union[None, Unset, str]):
        memoryset_id (Union[None, Unset, str]):
        memoryset_name (Union[None, Unset, str]):
        head_type (Union[Unset, RACHeadType]):
        weigh_memories (Union[None, Unset, bool]):
        min_memory_weight (Union[None, Unset, float]):
        memory_lookup_count (Union[None, Unset, int]):
        num_classes (Union[None, Unset, int]):
    """

    name: str
    description: Union[None, Unset, str] = UNSET
    memoryset_id: Union[None, Unset, str] = UNSET
    memoryset_name: Union[None, Unset, str] = UNSET
    head_type: Union[Unset, RACHeadType] = UNSET
    weigh_memories: Union[None, Unset, bool] = UNSET
    min_memory_weight: Union[None, Unset, float] = UNSET
    memory_lookup_count: Union[None, Unset, int] = UNSET
    num_classes: Union[None, Unset, int] = UNSET
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        name = self.name

        description: Union[None, Unset, str]
        if isinstance(self.description, Unset):
            description = UNSET
        else:
            description = self.description

        memoryset_id: Union[None, Unset, str]
        if isinstance(self.memoryset_id, Unset):
            memoryset_id = UNSET
        else:
            memoryset_id = self.memoryset_id

        memoryset_name: Union[None, Unset, str]
        if isinstance(self.memoryset_name, Unset):
            memoryset_name = UNSET
        else:
            memoryset_name = self.memoryset_name

        head_type: Union[Unset, str] = UNSET
        if not isinstance(self.head_type, Unset):
            head_type = self.head_type.value

        weigh_memories: Union[None, Unset, bool]
        if isinstance(self.weigh_memories, Unset):
            weigh_memories = UNSET
        else:
            weigh_memories = self.weigh_memories

        min_memory_weight: Union[None, Unset, float]
        if isinstance(self.min_memory_weight, Unset):
            min_memory_weight = UNSET
        else:
            min_memory_weight = self.min_memory_weight

        memory_lookup_count: Union[None, Unset, int]
        if isinstance(self.memory_lookup_count, Unset):
            memory_lookup_count = UNSET
        else:
            memory_lookup_count = self.memory_lookup_count

        num_classes: Union[None, Unset, int]
        if isinstance(self.num_classes, Unset):
            num_classes = UNSET
        else:
            num_classes = self.num_classes

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "name": name,
            }
        )
        if description is not UNSET:
            field_dict["description"] = description
        if memoryset_id is not UNSET:
            field_dict["memoryset_id"] = memoryset_id
        if memoryset_name is not UNSET:
            field_dict["memoryset_name"] = memoryset_name
        if head_type is not UNSET:
            field_dict["head_type"] = head_type
        if weigh_memories is not UNSET:
            field_dict["weigh_memories"] = weigh_memories
        if min_memory_weight is not UNSET:
            field_dict["min_memory_weight"] = min_memory_weight
        if memory_lookup_count is not UNSET:
            field_dict["memory_lookup_count"] = memory_lookup_count
        if num_classes is not UNSET:
            field_dict["num_classes"] = num_classes

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: dict[str, Any]) -> T:
        d = src_dict.copy()
        name = d.pop("name")

        def _parse_description(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        description = _parse_description(d.pop("description", UNSET))

        def _parse_memoryset_id(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        memoryset_id = _parse_memoryset_id(d.pop("memoryset_id", UNSET))

        def _parse_memoryset_name(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        memoryset_name = _parse_memoryset_name(d.pop("memoryset_name", UNSET))

        _head_type = d.pop("head_type", UNSET)
        head_type: Union[Unset, RACHeadType]
        if isinstance(_head_type, Unset):
            head_type = UNSET
        else:
            head_type = RACHeadType(_head_type)

        def _parse_weigh_memories(data: object) -> Union[None, Unset, bool]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, bool], data)

        weigh_memories = _parse_weigh_memories(d.pop("weigh_memories", UNSET))

        def _parse_min_memory_weight(data: object) -> Union[None, Unset, float]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, float], data)

        min_memory_weight = _parse_min_memory_weight(d.pop("min_memory_weight", UNSET))

        def _parse_memory_lookup_count(data: object) -> Union[None, Unset, int]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, int], data)

        memory_lookup_count = _parse_memory_lookup_count(d.pop("memory_lookup_count", UNSET))

        def _parse_num_classes(data: object) -> Union[None, Unset, int]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, int], data)

        num_classes = _parse_num_classes(d.pop("num_classes", UNSET))

        create_rac_model_request = cls(
            name=name,
            description=description,
            memoryset_id=memoryset_id,
            memoryset_name=memoryset_name,
            head_type=head_type,
            weigh_memories=weigh_memories,
            min_memory_weight=min_memory_weight,
            memory_lookup_count=memory_lookup_count,
            num_classes=num_classes,
        )

        create_rac_model_request.additional_properties = d
        return create_rac_model_request

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
