"""
This file is generated by the openapi-python-client tool via the generate_api_client.py script

It is a customized template from the openapi-python-client tool's default template:
https://github.com/openapi-generators/openapi-python-client/blob/861ef5622f10fc96d240dc9becb0edf94e61446c/openapi_python_client/templates/model.py.jinja

The main change is:
- Fix typing issues
"""

# flake8: noqa: C901

from enum import Enum
from typing import Any, List, Type, TypeVar, Union, cast

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..models.pretrained_embedding_model_name import PretrainedEmbeddingModelName
from ..types import UNSET, Unset

T = TypeVar("T", bound="CreateLabeledMemorysetRequest")


@_attrs_define
class CreateLabeledMemorysetRequest:
    """
    Attributes:
        name (str):
        datasource_label_column (str):
        datasource_value_column (str):
        description (Union[None, Unset, str]):
        datasource_id (Union[None, Unset, str]):
        datasource_name (Union[None, Unset, str]):
        datasource_source_id_column (Union[None, Unset, str]):
        remove_duplicates (Union[Unset, bool]):  Default: True.
        pretrained_embedding_model_name (Union[None, PretrainedEmbeddingModelName, Unset]):
        finetuned_embedding_model_id (Union[None, Unset, str]):
        finetuned_embedding_model_name (Union[None, Unset, str]):
        max_seq_length_override (Union[None, Unset, int]):
        label_names (Union[List[str], None, Unset]):
    """

    name: str
    datasource_label_column: str
    datasource_value_column: str
    description: Union[None, Unset, str] = UNSET
    datasource_id: Union[None, Unset, str] = UNSET
    datasource_name: Union[None, Unset, str] = UNSET
    datasource_source_id_column: Union[None, Unset, str] = UNSET
    remove_duplicates: Union[Unset, bool] = True
    pretrained_embedding_model_name: Union[None, PretrainedEmbeddingModelName, Unset] = UNSET
    finetuned_embedding_model_id: Union[None, Unset, str] = UNSET
    finetuned_embedding_model_name: Union[None, Unset, str] = UNSET
    max_seq_length_override: Union[None, Unset, int] = UNSET
    label_names: Union[List[str], None, Unset] = UNSET
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        name = self.name

        datasource_label_column = self.datasource_label_column

        datasource_value_column = self.datasource_value_column

        description: Union[None, Unset, str]
        if isinstance(self.description, Unset):
            description = UNSET
        else:
            description = self.description

        datasource_id: Union[None, Unset, str]
        if isinstance(self.datasource_id, Unset):
            datasource_id = UNSET
        else:
            datasource_id = self.datasource_id

        datasource_name: Union[None, Unset, str]
        if isinstance(self.datasource_name, Unset):
            datasource_name = UNSET
        else:
            datasource_name = self.datasource_name

        datasource_source_id_column: Union[None, Unset, str]
        if isinstance(self.datasource_source_id_column, Unset):
            datasource_source_id_column = UNSET
        else:
            datasource_source_id_column = self.datasource_source_id_column

        remove_duplicates = self.remove_duplicates

        pretrained_embedding_model_name: Union[None, Unset, str]
        if isinstance(self.pretrained_embedding_model_name, Unset):
            pretrained_embedding_model_name = UNSET
        elif isinstance(self.pretrained_embedding_model_name, PretrainedEmbeddingModelName):
            pretrained_embedding_model_name = (
                self.pretrained_embedding_model_name.value
                if isinstance(self.pretrained_embedding_model_name, Enum)
                else self.pretrained_embedding_model_name
            )
        else:
            pretrained_embedding_model_name = self.pretrained_embedding_model_name

        finetuned_embedding_model_id: Union[None, Unset, str]
        if isinstance(self.finetuned_embedding_model_id, Unset):
            finetuned_embedding_model_id = UNSET
        else:
            finetuned_embedding_model_id = self.finetuned_embedding_model_id

        finetuned_embedding_model_name: Union[None, Unset, str]
        if isinstance(self.finetuned_embedding_model_name, Unset):
            finetuned_embedding_model_name = UNSET
        else:
            finetuned_embedding_model_name = self.finetuned_embedding_model_name

        max_seq_length_override: Union[None, Unset, int]
        if isinstance(self.max_seq_length_override, Unset):
            max_seq_length_override = UNSET
        else:
            max_seq_length_override = self.max_seq_length_override

        label_names: Union[List[str], None, Unset]
        if isinstance(self.label_names, Unset):
            label_names = UNSET
        elif isinstance(self.label_names, list):
            label_names = self.label_names

        else:
            label_names = self.label_names

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "name": name,
                "datasource_label_column": datasource_label_column,
                "datasource_value_column": datasource_value_column,
            }
        )
        if description is not UNSET:
            field_dict["description"] = description
        if datasource_id is not UNSET:
            field_dict["datasource_id"] = datasource_id
        if datasource_name is not UNSET:
            field_dict["datasource_name"] = datasource_name
        if datasource_source_id_column is not UNSET:
            field_dict["datasource_source_id_column"] = datasource_source_id_column
        if remove_duplicates is not UNSET:
            field_dict["remove_duplicates"] = remove_duplicates
        if pretrained_embedding_model_name is not UNSET:
            field_dict["pretrained_embedding_model_name"] = pretrained_embedding_model_name
        if finetuned_embedding_model_id is not UNSET:
            field_dict["finetuned_embedding_model_id"] = finetuned_embedding_model_id
        if finetuned_embedding_model_name is not UNSET:
            field_dict["finetuned_embedding_model_name"] = finetuned_embedding_model_name
        if max_seq_length_override is not UNSET:
            field_dict["max_seq_length_override"] = max_seq_length_override
        if label_names is not UNSET:
            field_dict["label_names"] = label_names

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: dict[str, Any]) -> T:
        d = src_dict.copy()
        name = d.pop("name")

        datasource_label_column = d.pop("datasource_label_column")

        datasource_value_column = d.pop("datasource_value_column")

        def _parse_description(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        description = _parse_description(d.pop("description", UNSET))

        def _parse_datasource_id(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        datasource_id = _parse_datasource_id(d.pop("datasource_id", UNSET))

        def _parse_datasource_name(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        datasource_name = _parse_datasource_name(d.pop("datasource_name", UNSET))

        def _parse_datasource_source_id_column(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        datasource_source_id_column = _parse_datasource_source_id_column(d.pop("datasource_source_id_column", UNSET))

        remove_duplicates = d.pop("remove_duplicates", UNSET)

        def _parse_pretrained_embedding_model_name(data: object) -> Union[None, PretrainedEmbeddingModelName, Unset]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            try:
                if not isinstance(data, str):
                    raise TypeError()
                pretrained_embedding_model_name_type_0 = PretrainedEmbeddingModelName(data)

                return pretrained_embedding_model_name_type_0
            except:  # noqa: E722
                pass
            return cast(Union[None, PretrainedEmbeddingModelName, Unset], data)

        pretrained_embedding_model_name = _parse_pretrained_embedding_model_name(
            d.pop("pretrained_embedding_model_name", UNSET)
        )

        def _parse_finetuned_embedding_model_id(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        finetuned_embedding_model_id = _parse_finetuned_embedding_model_id(d.pop("finetuned_embedding_model_id", UNSET))

        def _parse_finetuned_embedding_model_name(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        finetuned_embedding_model_name = _parse_finetuned_embedding_model_name(
            d.pop("finetuned_embedding_model_name", UNSET)
        )

        def _parse_max_seq_length_override(data: object) -> Union[None, Unset, int]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, int], data)

        max_seq_length_override = _parse_max_seq_length_override(d.pop("max_seq_length_override", UNSET))

        def _parse_label_names(data: object) -> Union[List[str], None, Unset]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            try:
                if not isinstance(data, list):
                    raise TypeError()
                label_names_type_0 = cast(List[str], data)

                return label_names_type_0
            except:  # noqa: E722
                pass
            return cast(Union[List[str], None, Unset], data)

        label_names = _parse_label_names(d.pop("label_names", UNSET))

        create_labeled_memoryset_request = cls(
            name=name,
            datasource_label_column=datasource_label_column,
            datasource_value_column=datasource_value_column,
            description=description,
            datasource_id=datasource_id,
            datasource_name=datasource_name,
            datasource_source_id_column=datasource_source_id_column,
            remove_duplicates=remove_duplicates,
            pretrained_embedding_model_name=pretrained_embedding_model_name,
            finetuned_embedding_model_id=finetuned_embedding_model_id,
            finetuned_embedding_model_name=finetuned_embedding_model_name,
            max_seq_length_override=max_seq_length_override,
            label_names=label_names,
        )

        create_labeled_memoryset_request.additional_properties = d
        return create_labeled_memoryset_request

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
