"""
This file is generated by the openapi-python-client tool via the generate_api_client.py script

It is a customized template from the openapi-python-client tool's default template:
https://github.com/openapi-generators/openapi-python-client/blob/861ef5622f10fc96d240dc9becb0edf94e61446c/openapi_python_client/templates/model.py.jinja

The main change is:
- Fix typing issues
"""

# flake8: noqa: C901

import datetime
from enum import Enum
from typing import Any, List, Type, TypeVar, Union, cast

from attrs import define as _attrs_define
from attrs import field as _attrs_field
from dateutil.parser import isoparse

from ..models.create_api_key_response_scope_item import CreateApiKeyResponseScopeItem

T = TypeVar("T", bound="CreateApiKeyResponse")


@_attrs_define
class CreateApiKeyResponse:
    """
    Attributes:
        id (str):
        org_id (str):
        name (str):
        created_by (Union[None, str]):
        created_at (datetime.datetime):
        updated_at (datetime.datetime):
        scope (List[CreateApiKeyResponseScopeItem]):
        api_key (str):
    """

    id: str
    org_id: str
    name: str
    created_by: Union[None, str]
    created_at: datetime.datetime
    updated_at: datetime.datetime
    scope: List[CreateApiKeyResponseScopeItem]
    api_key: str
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        id = self.id

        org_id = self.org_id

        name = self.name

        created_by: Union[None, str]
        created_by = self.created_by

        created_at = self.created_at.isoformat()

        updated_at = self.updated_at.isoformat()

        scope = []
        for scope_item_data in self.scope:
            scope_item = scope_item_data.value if isinstance(scope_item_data, Enum) else scope_item_data
            scope.append(scope_item)

        api_key = self.api_key

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "id": id,
                "org_id": org_id,
                "name": name,
                "created_by": created_by,
                "created_at": created_at,
                "updated_at": updated_at,
                "scope": scope,
                "api_key": api_key,
            }
        )

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: dict[str, Any]) -> T:
        d = src_dict.copy()
        id = d.pop("id")

        org_id = d.pop("org_id")

        name = d.pop("name")

        def _parse_created_by(data: object) -> Union[None, str]:
            if data is None:
                return data
            return cast(Union[None, str], data)

        created_by = _parse_created_by(d.pop("created_by"))

        created_at = isoparse(d.pop("created_at"))

        updated_at = isoparse(d.pop("updated_at"))

        scope = []
        _scope = d.pop("scope")
        for scope_item_data in _scope:
            scope_item = CreateApiKeyResponseScopeItem(scope_item_data)

            scope.append(scope_item)

        api_key = d.pop("api_key")

        create_api_key_response = cls(
            id=id,
            org_id=org_id,
            name=name,
            created_by=created_by,
            created_at=created_at,
            updated_at=updated_at,
            scope=scope,
            api_key=api_key,
        )

        create_api_key_response.additional_properties = d
        return create_api_key_response

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
