"""
This file is generated by the openapi-python-client tool via the generate_api_client.py script

It is a customized template from the openapi-python-client tool's default template:
https://github.com/openapi-generators/openapi-python-client/blob/861ef5622f10fc96d240dc9becb0edf94e61446c/openapi_python_client/templates/model.py.jinja

The main change is:
- Fix typing issues
"""

# flake8: noqa: C901

from enum import Enum
from typing import Any, List, Type, TypeVar, Union, cast

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..models.column_type import ColumnType
from ..types import UNSET, Unset

T = TypeVar("T", bound="ColumnInfo")


@_attrs_define
class ColumnInfo:
    """Information about a column in a datasource

    Attributes:
        name (str):
        type (ColumnType): The type of a column in a datasource
        enum_options (Union[List[str], None, Unset]):
    """

    name: str
    type: ColumnType
    enum_options: Union[List[str], None, Unset] = UNSET
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        name = self.name

        type = self.type.value if isinstance(self.type, Enum) else self.type

        enum_options: Union[List[str], None, Unset]
        if isinstance(self.enum_options, Unset):
            enum_options = UNSET
        elif isinstance(self.enum_options, list):
            enum_options = self.enum_options

        else:
            enum_options = self.enum_options

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "name": name,
                "type": type,
            }
        )
        if enum_options is not UNSET:
            field_dict["enum_options"] = enum_options

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: dict[str, Any]) -> T:
        d = src_dict.copy()
        name = d.pop("name")

        type = ColumnType(d.pop("type"))

        def _parse_enum_options(data: object) -> Union[List[str], None, Unset]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            try:
                if not isinstance(data, list):
                    raise TypeError()
                enum_options_type_0 = cast(List[str], data)

                return enum_options_type_0
            except:  # noqa: E722
                pass
            return cast(Union[List[str], None, Unset], data)

        enum_options = _parse_enum_options(d.pop("enum_options", UNSET))

        column_info = cls(
            name=name,
            type=type,
            enum_options=enum_options,
        )

        column_info.additional_properties = d
        return column_info

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
