"""
This file is generated by the openapi-python-client tool via the generate_api_client.py script

It is a customized template from the openapi-python-client tool's default template:
https://github.com/openapi-generators/openapi-python-client/blob/861ef5622f10fc96d240dc9becb0edf94e61446c/openapi_python_client/templates/model.py.jinja

The main change is:
- Fix typing issues
"""

# flake8: noqa: C901

from enum import Enum
from typing import Any, Type, TypeVar, Union, cast

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..models.pretrained_embedding_model_name import PretrainedEmbeddingModelName
from ..types import UNSET, Unset

T = TypeVar("T", bound="CloneLabeledMemorysetRequest")


@_attrs_define
class CloneLabeledMemorysetRequest:
    """
    Attributes:
        name (str):
        description (Union[None, Unset, str]):
        pretrained_embedding_model_name (Union[None, PretrainedEmbeddingModelName, Unset]):
        finetuned_embedding_model_id (Union[None, Unset, str]):
        max_seq_length_override (Union[None, Unset, int]):
    """

    name: str
    description: Union[None, Unset, str] = UNSET
    pretrained_embedding_model_name: Union[None, PretrainedEmbeddingModelName, Unset] = UNSET
    finetuned_embedding_model_id: Union[None, Unset, str] = UNSET
    max_seq_length_override: Union[None, Unset, int] = UNSET
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        name = self.name

        description: Union[None, Unset, str]
        if isinstance(self.description, Unset):
            description = UNSET
        else:
            description = self.description

        pretrained_embedding_model_name: Union[None, Unset, str]
        if isinstance(self.pretrained_embedding_model_name, Unset):
            pretrained_embedding_model_name = UNSET
        elif isinstance(self.pretrained_embedding_model_name, PretrainedEmbeddingModelName):
            pretrained_embedding_model_name = (
                self.pretrained_embedding_model_name.value
                if isinstance(self.pretrained_embedding_model_name, Enum)
                else self.pretrained_embedding_model_name
            )
        else:
            pretrained_embedding_model_name = self.pretrained_embedding_model_name

        finetuned_embedding_model_id: Union[None, Unset, str]
        if isinstance(self.finetuned_embedding_model_id, Unset):
            finetuned_embedding_model_id = UNSET
        else:
            finetuned_embedding_model_id = self.finetuned_embedding_model_id

        max_seq_length_override: Union[None, Unset, int]
        if isinstance(self.max_seq_length_override, Unset):
            max_seq_length_override = UNSET
        else:
            max_seq_length_override = self.max_seq_length_override

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "name": name,
            }
        )
        if description is not UNSET:
            field_dict["description"] = description
        if pretrained_embedding_model_name is not UNSET:
            field_dict["pretrained_embedding_model_name"] = pretrained_embedding_model_name
        if finetuned_embedding_model_id is not UNSET:
            field_dict["finetuned_embedding_model_id"] = finetuned_embedding_model_id
        if max_seq_length_override is not UNSET:
            field_dict["max_seq_length_override"] = max_seq_length_override

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: dict[str, Any]) -> T:
        d = src_dict.copy()
        name = d.pop("name")

        def _parse_description(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        description = _parse_description(d.pop("description", UNSET))

        def _parse_pretrained_embedding_model_name(data: object) -> Union[None, PretrainedEmbeddingModelName, Unset]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            try:
                if not isinstance(data, str):
                    raise TypeError()
                pretrained_embedding_model_name_type_0 = PretrainedEmbeddingModelName(data)

                return pretrained_embedding_model_name_type_0
            except:  # noqa: E722
                pass
            return cast(Union[None, PretrainedEmbeddingModelName, Unset], data)

        pretrained_embedding_model_name = _parse_pretrained_embedding_model_name(
            d.pop("pretrained_embedding_model_name", UNSET)
        )

        def _parse_finetuned_embedding_model_id(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        finetuned_embedding_model_id = _parse_finetuned_embedding_model_id(d.pop("finetuned_embedding_model_id", UNSET))

        def _parse_max_seq_length_override(data: object) -> Union[None, Unset, int]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, int], data)

        max_seq_length_override = _parse_max_seq_length_override(d.pop("max_seq_length_override", UNSET))

        clone_labeled_memoryset_request = cls(
            name=name,
            description=description,
            pretrained_embedding_model_name=pretrained_embedding_model_name,
            finetuned_embedding_model_id=finetuned_embedding_model_id,
            max_seq_length_override=max_seq_length_override,
        )

        clone_labeled_memoryset_request.additional_properties = d
        return clone_labeled_memoryset_request

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
