"""
This file is generated by the openapi-python-client tool via the generate_api_client.py script

It is a customized template from the openapi-python-client tool's default template:
https://github.com/openapi-generators/openapi-python-client/blob/861ef5622f10fc96d240dc9becb0edf94e61446c/openapi_python_client/templates/model.py.jinja

The main change is:
- Fix typing issues
"""

# flake8: noqa: C901

from typing import TYPE_CHECKING, Any, Dict, Type, TypeVar, Union, cast

from attrs import define as _attrs_define
from attrs import field as _attrs_field

if TYPE_CHECKING:
    from ..models.precision_recall_curve import PrecisionRecallCurve
    from ..models.roc_curve import ROCCurve


T = TypeVar("T", bound="ClassificationEvaluationResult")


@_attrs_define
class ClassificationEvaluationResult:
    """
    Attributes:
        f1_score (float):
        accuracy (float):
        loss (float):
        precision_recall_curve (Union['PrecisionRecallCurve', None]):
        roc_curve (Union['ROCCurve', None]):
    """

    f1_score: float
    accuracy: float
    loss: float
    precision_recall_curve: Union["PrecisionRecallCurve", None]
    roc_curve: Union["ROCCurve", None]
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        from ..models.precision_recall_curve import PrecisionRecallCurve
        from ..models.roc_curve import ROCCurve

        f1_score = self.f1_score

        accuracy = self.accuracy

        loss = self.loss

        precision_recall_curve: Union[Dict[str, Any], None]
        if isinstance(self.precision_recall_curve, PrecisionRecallCurve):
            precision_recall_curve = self.precision_recall_curve.to_dict()
        else:
            precision_recall_curve = self.precision_recall_curve

        roc_curve: Union[Dict[str, Any], None]
        if isinstance(self.roc_curve, ROCCurve):
            roc_curve = self.roc_curve.to_dict()
        else:
            roc_curve = self.roc_curve

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "f1_score": f1_score,
                "accuracy": accuracy,
                "loss": loss,
                "precision_recall_curve": precision_recall_curve,
                "roc_curve": roc_curve,
            }
        )

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: dict[str, Any]) -> T:
        from ..models.precision_recall_curve import PrecisionRecallCurve
        from ..models.roc_curve import ROCCurve

        d = src_dict.copy()
        f1_score = d.pop("f1_score")

        accuracy = d.pop("accuracy")

        loss = d.pop("loss")

        def _parse_precision_recall_curve(data: object) -> Union["PrecisionRecallCurve", None]:
            if data is None:
                return data
            try:
                if not isinstance(data, dict):
                    raise TypeError()
                precision_recall_curve_type_0 = PrecisionRecallCurve.from_dict(data)

                return precision_recall_curve_type_0
            except:  # noqa: E722
                pass
            return cast(Union["PrecisionRecallCurve", None], data)

        precision_recall_curve = _parse_precision_recall_curve(d.pop("precision_recall_curve"))

        def _parse_roc_curve(data: object) -> Union["ROCCurve", None]:
            if data is None:
                return data
            try:
                if not isinstance(data, dict):
                    raise TypeError()
                roc_curve_type_0 = ROCCurve.from_dict(data)

                return roc_curve_type_0
            except:  # noqa: E722
                pass
            return cast(Union["ROCCurve", None], data)

        roc_curve = _parse_roc_curve(d.pop("roc_curve"))

        classification_evaluation_result = cls(
            f1_score=f1_score,
            accuracy=accuracy,
            loss=loss,
            precision_recall_curve=precision_recall_curve,
            roc_curve=roc_curve,
        )

        classification_evaluation_result.additional_properties = d
        return classification_evaluation_result

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
