"""
This file is generated by the openapi-python-client tool via the generate_api_client.py script

It is a customized template from the openapi-python-client tool's default template:
https://github.com/openapi-generators/openapi-python-client/blob/861ef5622f10fc96d240dc9becb0edf94e61446c/openapi_python_client/templates/model.py.jinja

The main change is:
- Fix typing issues
"""

# flake8: noqa: C901

from typing import TYPE_CHECKING, Any, List, Type, TypeVar

from attrs import define as _attrs_define
from attrs import field as _attrs_field

if TYPE_CHECKING:
    from ..models.label_class_metrics import LabelClassMetrics


T = TypeVar("T", bound="AnalyzeNeighborLabelsResult")


@_attrs_define
class AnalyzeNeighborLabelsResult:
    """
    Attributes:
        label_metrics (List['LabelClassMetrics']):
        neighbor_prediction_accuracy (float):
        mean_neighbor_label_confidence (float):
        mean_neighbor_label_entropy (float):
        mean_neighbor_predicted_label_ambiguity (float):
    """

    label_metrics: List["LabelClassMetrics"]
    neighbor_prediction_accuracy: float
    mean_neighbor_label_confidence: float
    mean_neighbor_label_entropy: float
    mean_neighbor_predicted_label_ambiguity: float
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        label_metrics = []
        for label_metrics_item_data in self.label_metrics:
            label_metrics_item = label_metrics_item_data.to_dict()
            label_metrics.append(label_metrics_item)

        neighbor_prediction_accuracy = self.neighbor_prediction_accuracy

        mean_neighbor_label_confidence = self.mean_neighbor_label_confidence

        mean_neighbor_label_entropy = self.mean_neighbor_label_entropy

        mean_neighbor_predicted_label_ambiguity = self.mean_neighbor_predicted_label_ambiguity

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "label_metrics": label_metrics,
                "neighbor_prediction_accuracy": neighbor_prediction_accuracy,
                "mean_neighbor_label_confidence": mean_neighbor_label_confidence,
                "mean_neighbor_label_entropy": mean_neighbor_label_entropy,
                "mean_neighbor_predicted_label_ambiguity": mean_neighbor_predicted_label_ambiguity,
            }
        )

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: dict[str, Any]) -> T:
        from ..models.label_class_metrics import LabelClassMetrics

        d = src_dict.copy()
        label_metrics = []
        _label_metrics = d.pop("label_metrics")
        for label_metrics_item_data in _label_metrics:
            label_metrics_item = LabelClassMetrics.from_dict(label_metrics_item_data)

            label_metrics.append(label_metrics_item)

        neighbor_prediction_accuracy = d.pop("neighbor_prediction_accuracy")

        mean_neighbor_label_confidence = d.pop("mean_neighbor_label_confidence")

        mean_neighbor_label_entropy = d.pop("mean_neighbor_label_entropy")

        mean_neighbor_predicted_label_ambiguity = d.pop("mean_neighbor_predicted_label_ambiguity")

        analyze_neighbor_labels_result = cls(
            label_metrics=label_metrics,
            neighbor_prediction_accuracy=neighbor_prediction_accuracy,
            mean_neighbor_label_confidence=mean_neighbor_label_confidence,
            mean_neighbor_label_entropy=mean_neighbor_label_entropy,
            mean_neighbor_predicted_label_ambiguity=mean_neighbor_predicted_label_ambiguity,
        )

        analyze_neighbor_labels_result.additional_properties = d
        return analyze_neighbor_labels_result

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
