"""
This file is generated by the openapi-python-client tool via the generate_api_client.py script

It is a customized template from the openapi-python-client tool's default template:
https://github.com/openapi-generators/openapi-python-client/blob/861ef5622f10fc96d240dc9becb0edf94e61446c/openapi_python_client/templates/endpoint_module.py.jinja

The main changes are:
- Update the API call responses to either return the successful response type or raise an error by:
    - Updating the _parse_response function to raise an error if the response status code is not in the 2xx range
- Inject a client into every method via a context manager
"""

from http import HTTPStatus
from typing import Any, Dict, List

import httpx

from ...client import _client_context
from ...errors import get_error_for_response
from ...models.label_prediction_with_memories_and_feedback import LabelPredictionWithMemoriesAndFeedback
from ...models.list_predictions_request import ListPredictionsRequest
from ...types import Response


def _get_kwargs(
    *,
    body: ListPredictionsRequest,
) -> dict[str, Any]:
    headers: Dict[str, Any] = {}

    _kwargs: dict[str, Any] = {
        "method": "post",
        "url": "/telemetry/prediction",
    }

    _body = body.to_dict()

    _kwargs["json"] = _body
    headers["Content-Type"] = "application/json"

    _kwargs["headers"] = headers
    return _kwargs


def _parse_response(*, response: httpx.Response) -> List["LabelPredictionWithMemoriesAndFeedback"]:
    if response.status_code == 200:
        response_200 = []
        _response_200 = response.json()
        for response_200_item_data in _response_200:
            response_200_item = LabelPredictionWithMemoriesAndFeedback.from_dict(response_200_item_data)

            response_200.append(response_200_item)

        return response_200
    if response.status_code == 401:
        raise get_error_for_response(response)
    if response.status_code == 500:
        raise get_error_for_response(response)
    if response.status_code == 503:
        raise get_error_for_response(response)
    if response.status_code == 404:
        raise get_error_for_response(response)
    else:
        raise get_error_for_response(response)


def _build_response(*, response: httpx.Response) -> Response[List["LabelPredictionWithMemoriesAndFeedback"]]:
    return Response(
        status_code=HTTPStatus(response.status_code),
        content=response.content,
        headers=response.headers,
        parsed=_parse_response(response=response),
    )


def sync_detailed(
    *,
    body: ListPredictionsRequest,
) -> Response[List["LabelPredictionWithMemoriesAndFeedback"]]:
    """List Predictions

    Args:
        body (ListPredictionsRequest):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[List['LabelPredictionWithMemoriesAndFeedback']]
    """

    kwargs = _get_kwargs(
        body=body,
    )

    with _client_context() as client:
        response = client.get_httpx_client().request(
            **kwargs,
        )

        return _build_response(response=response)


def sync(
    *,
    body: ListPredictionsRequest,
) -> List["LabelPredictionWithMemoriesAndFeedback"]:
    """List Predictions

    Args:
        body (ListPredictionsRequest):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        List['LabelPredictionWithMemoriesAndFeedback']
    """

    return sync_detailed(
        body=body,
    ).parsed


async def asyncio_detailed(
    *,
    body: ListPredictionsRequest,
) -> Response[List["LabelPredictionWithMemoriesAndFeedback"]]:
    """List Predictions

    Args:
        body (ListPredictionsRequest):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[List['LabelPredictionWithMemoriesAndFeedback']]
    """

    kwargs = _get_kwargs(
        body=body,
    )

    with _client_context() as client:
        response = await client.get_async_httpx_client().request(**kwargs)

    return _build_response(response=response)


async def asyncio(
    *,
    body: ListPredictionsRequest,
) -> List["LabelPredictionWithMemoriesAndFeedback"]:
    """List Predictions

    Args:
        body (ListPredictionsRequest):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        List['LabelPredictionWithMemoriesAndFeedback']
    """

    return (
        await asyncio_detailed(
            body=body,
        )
    ).parsed
