"""
This file is generated by the openapi-python-client tool via the generate_api_client.py script

It is a customized template from the openapi-python-client tool's default template:
https://github.com/openapi-generators/openapi-python-client/blob/861ef5622f10fc96d240dc9becb0edf94e61446c/openapi_python_client/templates/endpoint_module.py.jinja

The main changes are:
- Update the API call responses to either return the successful response type or raise an error by:
    - Updating the _parse_response function to raise an error if the response status code is not in the 2xx range
- Inject a client into every method via a context manager
"""

from enum import Enum
from http import HTTPStatus
from typing import Any, Dict, List, Union

import httpx

from ...client import _client_context
from ...errors import get_error_for_response
from ...models.task import Task
from ...models.task_status import TaskStatus
from ...types import UNSET, Response, Unset


def _get_kwargs(
    *,
    status: Union[List[TaskStatus], None, TaskStatus, Unset] = UNSET,
    type: Union[List[str], None, Unset, str] = UNSET,
    limit: Union[Unset, int] = 100,
    offset: Union[Unset, int] = 0,
) -> dict[str, Any]:
    params: Dict[str, Any] = {}

    json_status: Union[List[str], None, Unset, str]
    if isinstance(status, Unset):
        json_status = UNSET
    elif isinstance(status, TaskStatus):
        json_status = status.value if isinstance(status, Enum) else status
    elif isinstance(status, list):
        json_status = []
        for status_type_1_item_data in status:
            status_type_1_item = (
                status_type_1_item_data.value if isinstance(status_type_1_item_data, Enum) else status_type_1_item_data
            )
            json_status.append(status_type_1_item)

    else:
        json_status = status
    params["status"] = json_status

    json_type: Union[List[str], None, Unset, str]
    if isinstance(type, Unset):
        json_type = UNSET
    elif isinstance(type, list):
        json_type = type

    else:
        json_type = type
    params["type"] = json_type

    params["limit"] = limit

    params["offset"] = offset

    params = {k: v for k, v in params.items() if v is not UNSET and v is not None}

    _kwargs: dict[str, Any] = {
        "method": "get",
        "url": "/task",
        "params": params,
    }

    return _kwargs


def _parse_response(*, response: httpx.Response) -> List["Task"]:
    if response.status_code == 200:
        response_200 = []
        _response_200 = response.json()
        for response_200_item_data in _response_200:
            response_200_item = Task.from_dict(response_200_item_data)

            response_200.append(response_200_item)

        return response_200
    if response.status_code == 401:
        raise get_error_for_response(response)
    if response.status_code == 500:
        raise get_error_for_response(response)
    if response.status_code == 503:
        raise get_error_for_response(response)
    if response.status_code == 404:
        raise get_error_for_response(response)
    else:
        raise get_error_for_response(response)


def _build_response(*, response: httpx.Response) -> Response[List["Task"]]:
    return Response(
        status_code=HTTPStatus(response.status_code),
        content=response.content,
        headers=response.headers,
        parsed=_parse_response(response=response),
    )


def sync_detailed(
    *,
    status: Union[List[TaskStatus], None, TaskStatus, Unset] = UNSET,
    type: Union[List[str], None, Unset, str] = UNSET,
    limit: Union[Unset, int] = 100,
    offset: Union[Unset, int] = 0,
) -> Response[List["Task"]]:
    """List Tasks

    Args:
        status (Union[List[TaskStatus], None, TaskStatus, Unset]):
        type (Union[List[str], None, Unset, str]):
        limit (Union[Unset, int]):  Default: 100.
        offset (Union[Unset, int]):  Default: 0.

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[List['Task']]
    """

    kwargs = _get_kwargs(
        status=status,
        type=type,
        limit=limit,
        offset=offset,
    )

    with _client_context() as client:
        response = client.get_httpx_client().request(
            **kwargs,
        )

        return _build_response(response=response)


def sync(
    *,
    status: Union[List[TaskStatus], None, TaskStatus, Unset] = UNSET,
    type: Union[List[str], None, Unset, str] = UNSET,
    limit: Union[Unset, int] = 100,
    offset: Union[Unset, int] = 0,
) -> List["Task"]:
    """List Tasks

    Args:
        status (Union[List[TaskStatus], None, TaskStatus, Unset]):
        type (Union[List[str], None, Unset, str]):
        limit (Union[Unset, int]):  Default: 100.
        offset (Union[Unset, int]):  Default: 0.

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        List['Task']
    """

    return sync_detailed(
        status=status,
        type=type,
        limit=limit,
        offset=offset,
    ).parsed


async def asyncio_detailed(
    *,
    status: Union[List[TaskStatus], None, TaskStatus, Unset] = UNSET,
    type: Union[List[str], None, Unset, str] = UNSET,
    limit: Union[Unset, int] = 100,
    offset: Union[Unset, int] = 0,
) -> Response[List["Task"]]:
    """List Tasks

    Args:
        status (Union[List[TaskStatus], None, TaskStatus, Unset]):
        type (Union[List[str], None, Unset, str]):
        limit (Union[Unset, int]):  Default: 100.
        offset (Union[Unset, int]):  Default: 0.

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[List['Task']]
    """

    kwargs = _get_kwargs(
        status=status,
        type=type,
        limit=limit,
        offset=offset,
    )

    with _client_context() as client:
        response = await client.get_async_httpx_client().request(**kwargs)

    return _build_response(response=response)


async def asyncio(
    *,
    status: Union[List[TaskStatus], None, TaskStatus, Unset] = UNSET,
    type: Union[List[str], None, Unset, str] = UNSET,
    limit: Union[Unset, int] = 100,
    offset: Union[Unset, int] = 0,
) -> List["Task"]:
    """List Tasks

    Args:
        status (Union[List[TaskStatus], None, TaskStatus, Unset]):
        type (Union[List[str], None, Unset, str]):
        limit (Union[Unset, int]):  Default: 100.
        offset (Union[Unset, int]):  Default: 0.

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        List['Task']
    """

    return (
        await asyncio_detailed(
            status=status,
            type=type,
            limit=limit,
            offset=offset,
        )
    ).parsed
