"""
This file is generated by the openapi-python-client tool via the generate_api_client.py script

It is a customized template from the openapi-python-client tool's default template:
https://github.com/openapi-generators/openapi-python-client/blob/861ef5622f10fc96d240dc9becb0edf94e61446c/openapi_python_client/templates/endpoint_module.py.jinja

The main changes are:
- Update the API call responses to either return the successful response type or raise an error by:
    - Updating the _parse_response function to raise an error if the response status code is not in the 2xx range
- Inject a client into every method via a context manager
"""

from enum import Enum
from http import HTTPStatus
from typing import Any, Dict, List, Union

import httpx

from ...client import _client_context
from ...errors import get_error_for_response
from ...models.memoryset_analysis_response import MemorysetAnalysisResponse
from ...models.task_status import TaskStatus
from ...types import UNSET, Response, Unset


def _get_kwargs(
    name_or_id: str,
    *,
    status: Union[None, TaskStatus, Unset] = UNSET,
    limit: Union[None, Unset, int] = 100,
    offset: Union[None, Unset, int] = 0,
) -> dict[str, Any]:
    params: Dict[str, Any] = {}

    json_status: Union[None, Unset, str]
    if isinstance(status, Unset):
        json_status = UNSET
    elif isinstance(status, TaskStatus):
        json_status = status.value if isinstance(status, Enum) else status
    else:
        json_status = status
    params["status"] = json_status

    json_limit: Union[None, Unset, int]
    if isinstance(limit, Unset):
        json_limit = UNSET
    else:
        json_limit = limit
    params["limit"] = json_limit

    json_offset: Union[None, Unset, int]
    if isinstance(offset, Unset):
        json_offset = UNSET
    else:
        json_offset = offset
    params["offset"] = json_offset

    params = {k: v for k, v in params.items() if v is not UNSET and v is not None}

    _kwargs: dict[str, Any] = {
        "method": "get",
        "url": f"/memoryset/{name_or_id}/analysis",
        "params": params,
    }

    return _kwargs


def _parse_response(*, response: httpx.Response) -> List["MemorysetAnalysisResponse"]:
    if response.status_code == 200:
        response_200 = []
        _response_200 = response.json()
        for response_200_item_data in _response_200:
            response_200_item = MemorysetAnalysisResponse.from_dict(response_200_item_data)

            response_200.append(response_200_item)

        return response_200
    if response.status_code == 401:
        raise get_error_for_response(response)
    if response.status_code == 500:
        raise get_error_for_response(response)
    if response.status_code == 503:
        raise get_error_for_response(response)
    if response.status_code == 404:
        raise get_error_for_response(response)
    else:
        raise get_error_for_response(response)


def _build_response(*, response: httpx.Response) -> Response[List["MemorysetAnalysisResponse"]]:
    return Response(
        status_code=HTTPStatus(response.status_code),
        content=response.content,
        headers=response.headers,
        parsed=_parse_response(response=response),
    )


def sync_detailed(
    name_or_id: str,
    *,
    status: Union[None, TaskStatus, Unset] = UNSET,
    limit: Union[None, Unset, int] = 100,
    offset: Union[None, Unset, int] = 0,
) -> Response[List["MemorysetAnalysisResponse"]]:
    """List Analyses

    Args:
        name_or_id (str):
        status (Union[None, TaskStatus, Unset]):
        limit (Union[None, Unset, int]):  Default: 100.
        offset (Union[None, Unset, int]):  Default: 0.

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[List['MemorysetAnalysisResponse']]
    """

    kwargs = _get_kwargs(
        name_or_id=name_or_id,
        status=status,
        limit=limit,
        offset=offset,
    )

    with _client_context() as client:
        response = client.get_httpx_client().request(
            **kwargs,
        )

        return _build_response(response=response)


def sync(
    name_or_id: str,
    *,
    status: Union[None, TaskStatus, Unset] = UNSET,
    limit: Union[None, Unset, int] = 100,
    offset: Union[None, Unset, int] = 0,
) -> List["MemorysetAnalysisResponse"]:
    """List Analyses

    Args:
        name_or_id (str):
        status (Union[None, TaskStatus, Unset]):
        limit (Union[None, Unset, int]):  Default: 100.
        offset (Union[None, Unset, int]):  Default: 0.

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        List['MemorysetAnalysisResponse']
    """

    return sync_detailed(
        name_or_id=name_or_id,
        status=status,
        limit=limit,
        offset=offset,
    ).parsed


async def asyncio_detailed(
    name_or_id: str,
    *,
    status: Union[None, TaskStatus, Unset] = UNSET,
    limit: Union[None, Unset, int] = 100,
    offset: Union[None, Unset, int] = 0,
) -> Response[List["MemorysetAnalysisResponse"]]:
    """List Analyses

    Args:
        name_or_id (str):
        status (Union[None, TaskStatus, Unset]):
        limit (Union[None, Unset, int]):  Default: 100.
        offset (Union[None, Unset, int]):  Default: 0.

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[List['MemorysetAnalysisResponse']]
    """

    kwargs = _get_kwargs(
        name_or_id=name_or_id,
        status=status,
        limit=limit,
        offset=offset,
    )

    with _client_context() as client:
        response = await client.get_async_httpx_client().request(**kwargs)

    return _build_response(response=response)


async def asyncio(
    name_or_id: str,
    *,
    status: Union[None, TaskStatus, Unset] = UNSET,
    limit: Union[None, Unset, int] = 100,
    offset: Union[None, Unset, int] = 0,
) -> List["MemorysetAnalysisResponse"]:
    """List Analyses

    Args:
        name_or_id (str):
        status (Union[None, TaskStatus, Unset]):
        limit (Union[None, Unset, int]):  Default: 100.
        offset (Union[None, Unset, int]):  Default: 0.

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        List['MemorysetAnalysisResponse']
    """

    return (
        await asyncio_detailed(
            name_or_id=name_or_id,
            status=status,
            limit=limit,
            offset=offset,
        )
    ).parsed
