"""
This file is generated by the openapi-python-client tool via the generate_api_client.py script

It is a customized template from the openapi-python-client tool's default template:
https://github.com/openapi-generators/openapi-python-client/blob/861ef5622f10fc96d240dc9becb0edf94e61446c/openapi_python_client/templates/endpoint_module.py.jinja

The main changes are:
- Update the API call responses to either return the successful response type or raise an error by:
    - Updating the _parse_response function to raise an error if the response status code is not in the 2xx range
- Inject a client into every method via a context manager
"""

from http import HTTPStatus
from typing import Any, Dict, List, cast

import httpx

from ...client import _client_context
from ...errors import get_error_for_response
from ...models.embed_request import EmbedRequest
from ...types import Response


def _get_kwargs(
    name_or_id: str,
    *,
    body: EmbedRequest,
) -> dict[str, Any]:
    headers: Dict[str, Any] = {}

    _kwargs: dict[str, Any] = {
        "method": "post",
        "url": f"/gpu/finetuned_embedding_model/{name_or_id}/embedding",
    }

    _body = body.to_dict()

    _kwargs["json"] = _body
    headers["Content-Type"] = "application/json"

    _kwargs["headers"] = headers
    return _kwargs


def _parse_response(*, response: httpx.Response) -> List[List[float]]:
    if response.status_code == 200:
        response_200 = []
        _response_200 = response.json()
        for response_200_item_data in _response_200:
            response_200_item = cast(List[float], response_200_item_data)

            response_200.append(response_200_item)

        return response_200
    if response.status_code == 401:
        raise get_error_for_response(response)
    if response.status_code == 500:
        raise get_error_for_response(response)
    if response.status_code == 503:
        raise get_error_for_response(response)
    if response.status_code == 404:
        raise get_error_for_response(response)
    if response.status_code == 409:
        raise get_error_for_response(response)
    else:
        raise get_error_for_response(response)


def _build_response(*, response: httpx.Response) -> Response[List[List[float]]]:
    return Response(
        status_code=HTTPStatus(response.status_code),
        content=response.content,
        headers=response.headers,
        parsed=_parse_response(response=response),
    )


def sync_detailed(
    name_or_id: str,
    *,
    body: EmbedRequest,
) -> Response[List[List[float]]]:
    """Embed With Finetuned Model

    Args:
        name_or_id (str):
        body (EmbedRequest):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[List[List[float]]]
    """

    kwargs = _get_kwargs(
        name_or_id=name_or_id,
        body=body,
    )

    with _client_context() as client:
        response = client.get_httpx_client().request(
            **kwargs,
        )

        return _build_response(response=response)


def sync(
    name_or_id: str,
    *,
    body: EmbedRequest,
) -> List[List[float]]:
    """Embed With Finetuned Model

    Args:
        name_or_id (str):
        body (EmbedRequest):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        List[List[float]]
    """

    return sync_detailed(
        name_or_id=name_or_id,
        body=body,
    ).parsed


async def asyncio_detailed(
    name_or_id: str,
    *,
    body: EmbedRequest,
) -> Response[List[List[float]]]:
    """Embed With Finetuned Model

    Args:
        name_or_id (str):
        body (EmbedRequest):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[List[List[float]]]
    """

    kwargs = _get_kwargs(
        name_or_id=name_or_id,
        body=body,
    )

    with _client_context() as client:
        response = await client.get_async_httpx_client().request(**kwargs)

    return _build_response(response=response)


async def asyncio(
    name_or_id: str,
    *,
    body: EmbedRequest,
) -> List[List[float]]:
    """Embed With Finetuned Model

    Args:
        name_or_id (str):
        body (EmbedRequest):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        List[List[float]]
    """

    return (
        await asyncio_detailed(
            name_or_id=name_or_id,
            body=body,
        )
    ).parsed
