"""
This file is generated by the openapi-python-client tool via the generate_api_client.py script

It is a customized template from the openapi-python-client tool's default template:
https://github.com/openapi-generators/openapi-python-client/blob/861ef5622f10fc96d240dc9becb0edf94e61446c/openapi_python_client/templates/endpoint_module.py.jinja

The main changes are:
- Update the API call responses to either return the successful response type or raise an error by:
    - Updating the _parse_response function to raise an error if the response status code is not in the 2xx range
- Inject a client into every method via a context manager
"""

from http import HTTPStatus
from typing import Any

import httpx

from ...client import _client_context
from ...errors import get_error_for_response
from ...types import Response


def _get_kwargs(
    name_or_id: str,
) -> dict[str, Any]:
    _kwargs: dict[str, Any] = {
        "method": "delete",
        "url": f"/classification_model/{name_or_id}",
    }

    return _kwargs


def _parse_response(*, response: httpx.Response) -> None:
    if response.status_code == 204:
        response_204 = None
        return response_204
    if response.status_code == 401:
        raise get_error_for_response(response)
    if response.status_code == 500:
        raise get_error_for_response(response)
    if response.status_code == 503:
        raise get_error_for_response(response)
    if response.status_code == 404:
        raise get_error_for_response(response)
    else:
        raise get_error_for_response(response)


def _build_response(*, response: httpx.Response) -> Response[None]:
    return Response(
        status_code=HTTPStatus(response.status_code),
        content=response.content,
        headers=response.headers,
        parsed=_parse_response(response=response),
    )


def sync_detailed(
    name_or_id: str,
) -> Response[None]:
    """Delete Model

    Args:
        name_or_id (str):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[None]
    """

    kwargs = _get_kwargs(
        name_or_id=name_or_id,
    )

    with _client_context() as client:
        response = client.get_httpx_client().request(
            **kwargs,
        )

        return _build_response(response=response)


def sync(
    name_or_id: str,
) -> None:
    """Delete Model

    Args:
        name_or_id (str):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        None
    """

    return sync_detailed(
        name_or_id=name_or_id,
    ).parsed


async def asyncio_detailed(
    name_or_id: str,
) -> Response[None]:
    """Delete Model

    Args:
        name_or_id (str):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[None]
    """

    kwargs = _get_kwargs(
        name_or_id=name_or_id,
    )

    with _client_context() as client:
        response = await client.get_async_httpx_client().request(**kwargs)

    return _build_response(response=response)


async def asyncio(
    name_or_id: str,
) -> None:
    """Delete Model

    Args:
        name_or_id (str):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        None
    """

    return (
        await asyncio_detailed(
            name_or_id=name_or_id,
        )
    ).parsed
