"""
    Togai Apis

    APIs for Togai App  # noqa: E501

    The version of the OpenAPI document: 1.0
    Contact: engg@togai.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from togai_client.api_client import ApiClient, Endpoint as _Endpoint
from togai_client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from togai_client.model.create_price_plan_request import CreatePricePlanRequest
from togai_client.model.error_response import ErrorResponse
from togai_client.model.price_plan import PricePlan
from togai_client.model.price_plan_paginated_response import PricePlanPaginatedResponse
from togai_client.model.update_price_plan_request import UpdatePricePlanRequest


class PricePlansApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.activate_price_plan_endpoint = _Endpoint(
            settings={
                'response_type': (PricePlan,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/price_plans/{price_plan_name}/activate',
                'operation_id': 'activate_price_plan',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'price_plan_name',
                ],
                'required': [
                    'price_plan_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'price_plan_name',
                ]
            },
            root_map={
                'validations': {
                    ('price_plan_name',): {
                        'max_length': 50,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'price_plan_name':
                        (str,),
                },
                'attribute_map': {
                    'price_plan_name': 'price_plan_name',
                },
                'location_map': {
                    'price_plan_name': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.create_price_plan_endpoint = _Endpoint(
            settings={
                'response_type': (PricePlan,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/price_plans',
                'operation_id': 'create_price_plan',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'create_price_plan_request',
                ],
                'required': [
                    'create_price_plan_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'create_price_plan_request':
                        (CreatePricePlanRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'create_price_plan_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.get_price_plan_endpoint = _Endpoint(
            settings={
                'response_type': (PricePlan,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/price_plans/{price_plan_name}',
                'operation_id': 'get_price_plan',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'price_plan_name',
                ],
                'required': [
                    'price_plan_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'price_plan_name',
                ]
            },
            root_map={
                'validations': {
                    ('price_plan_name',): {
                        'max_length': 50,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'price_plan_name':
                        (str,),
                },
                'attribute_map': {
                    'price_plan_name': 'price_plan_name',
                },
                'location_map': {
                    'price_plan_name': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_price_plans_endpoint = _Endpoint(
            settings={
                'response_type': (PricePlanPaginatedResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/price_plans',
                'operation_id': 'get_price_plans',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'next_token',
                    'page_size',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'next_token':
                        (str,),
                    'page_size':
                        (str,),
                },
                'attribute_map': {
                    'next_token': 'nextToken',
                    'page_size': 'pageSize',
                },
                'location_map': {
                    'next_token': 'query',
                    'page_size': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.update_price_plan_endpoint = _Endpoint(
            settings={
                'response_type': (PricePlan,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/price_plans/{price_plan_name}',
                'operation_id': 'update_price_plan',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'price_plan_name',
                    'update_price_plan_request',
                ],
                'required': [
                    'price_plan_name',
                    'update_price_plan_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'price_plan_name',
                ]
            },
            root_map={
                'validations': {
                    ('price_plan_name',): {
                        'max_length': 50,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'price_plan_name':
                        (str,),
                    'update_price_plan_request':
                        (UpdatePricePlanRequest,),
                },
                'attribute_map': {
                    'price_plan_name': 'price_plan_name',
                },
                'location_map': {
                    'price_plan_name': 'path',
                    'update_price_plan_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )

    def activate_price_plan(
        self,
        price_plan_name,
        **kwargs
    ):
        """Activate a price plan  # noqa: E501

        Activate a price plan  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.activate_price_plan(price_plan_name, async_req=True)
        >>> result = thread.get()

        Args:
            price_plan_name (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            PricePlan
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['price_plan_name'] = \
            price_plan_name
        return self.activate_price_plan_endpoint.call_with_http_info(**kwargs)

    def create_price_plan(
        self,
        create_price_plan_request,
        **kwargs
    ):
        """Create a price plan  # noqa: E501

        Create a price plan  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_price_plan(create_price_plan_request, async_req=True)
        >>> result = thread.get()

        Args:
            create_price_plan_request (CreatePricePlanRequest): Payload to create price plan

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            PricePlan
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['create_price_plan_request'] = \
            create_price_plan_request
        return self.create_price_plan_endpoint.call_with_http_info(**kwargs)

    def get_price_plan(
        self,
        price_plan_name,
        **kwargs
    ):
        """Get a price plan  # noqa: E501

        Get a price plan  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_price_plan(price_plan_name, async_req=True)
        >>> result = thread.get()

        Args:
            price_plan_name (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            PricePlan
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['price_plan_name'] = \
            price_plan_name
        return self.get_price_plan_endpoint.call_with_http_info(**kwargs)

    def get_price_plans(
        self,
        **kwargs
    ):
        """List price plans  # noqa: E501

        List price plans with pagination and sort  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_price_plans(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            next_token (str): [optional]
            page_size (str): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            PricePlanPaginatedResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.get_price_plans_endpoint.call_with_http_info(**kwargs)

    def update_price_plan(
        self,
        price_plan_name,
        update_price_plan_request,
        **kwargs
    ):
        """Update a price plan  # noqa: E501

        Update a price plan  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_price_plan(price_plan_name, update_price_plan_request, async_req=True)
        >>> result = thread.get()

        Args:
            price_plan_name (str):
            update_price_plan_request (UpdatePricePlanRequest): Payload to update price plan

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            PricePlan
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['price_plan_name'] = \
            price_plan_name
        kwargs['update_price_plan_request'] = \
            update_price_plan_request
        return self.update_price_plan_endpoint.call_with_http_info(**kwargs)

