"""
    Togai Apis

    APIs for Togai App  # noqa: E501

    The version of the OpenAPI document: 1.0
    Contact: engg@togai.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from togai_client.api_client import ApiClient, Endpoint as _Endpoint
from togai_client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from togai_client.model.account import Account
from togai_client.model.account_paginated_response import AccountPaginatedResponse
from togai_client.model.add_account_aliases_request import AddAccountAliasesRequest
from togai_client.model.associate_price_plan_request import AssociatePricePlanRequest
from togai_client.model.associate_price_plan_response import AssociatePricePlanResponse
from togai_client.model.base_success_response import BaseSuccessResponse
from togai_client.model.create_account_request import CreateAccountRequest
from togai_client.model.error_response import ErrorResponse
from togai_client.model.remove_account_aliases_request import RemoveAccountAliasesRequest
from togai_client.model.update_account_request import UpdateAccountRequest


class AccountsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.add_aliases_endpoint = _Endpoint(
            settings={
                'response_type': (Account,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/customers/{customer_id}/accounts/{account_id}/add_aliases',
                'operation_id': 'add_aliases',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'customer_id',
                    'account_id',
                    'add_account_aliases_request',
                ],
                'required': [
                    'customer_id',
                    'account_id',
                    'add_account_aliases_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'customer_id',
                    'account_id',
                ]
            },
            root_map={
                'validations': {
                    ('customer_id',): {
                        'max_length': 50,
                    },
                    ('account_id',): {
                        'max_length': 50,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'customer_id':
                        (str,),
                    'account_id':
                        (str,),
                    'add_account_aliases_request':
                        (AddAccountAliasesRequest,),
                },
                'attribute_map': {
                    'customer_id': 'customer_id',
                    'account_id': 'account_id',
                },
                'location_map': {
                    'customer_id': 'path',
                    'account_id': 'path',
                    'add_account_aliases_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.associate_price_plan_endpoint = _Endpoint(
            settings={
                'response_type': (AssociatePricePlanResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/customers/{customer_id}/accounts/{account_id}/price_plans',
                'operation_id': 'associate_price_plan',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'customer_id',
                    'account_id',
                    'associate_price_plan_request',
                ],
                'required': [
                    'customer_id',
                    'account_id',
                    'associate_price_plan_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'customer_id',
                    'account_id',
                ]
            },
            root_map={
                'validations': {
                    ('customer_id',): {
                        'max_length': 50,
                    },
                    ('account_id',): {
                        'max_length': 50,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'customer_id':
                        (str,),
                    'account_id':
                        (str,),
                    'associate_price_plan_request':
                        (AssociatePricePlanRequest,),
                },
                'attribute_map': {
                    'customer_id': 'customer_id',
                    'account_id': 'account_id',
                },
                'location_map': {
                    'customer_id': 'path',
                    'account_id': 'path',
                    'associate_price_plan_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_account_endpoint = _Endpoint(
            settings={
                'response_type': (Account,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/customers/{customer_id}/accounts',
                'operation_id': 'create_account',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'customer_id',
                    'create_account_request',
                ],
                'required': [
                    'customer_id',
                    'create_account_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'customer_id',
                ]
            },
            root_map={
                'validations': {
                    ('customer_id',): {
                        'max_length': 50,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'customer_id':
                        (str,),
                    'create_account_request':
                        (CreateAccountRequest,),
                },
                'attribute_map': {
                    'customer_id': 'customer_id',
                },
                'location_map': {
                    'customer_id': 'path',
                    'create_account_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.delete_account_endpoint = _Endpoint(
            settings={
                'response_type': (BaseSuccessResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/customers/{customer_id}/accounts/{account_id}',
                'operation_id': 'delete_account',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'customer_id',
                    'account_id',
                ],
                'required': [
                    'customer_id',
                    'account_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'customer_id',
                    'account_id',
                ]
            },
            root_map={
                'validations': {
                    ('customer_id',): {
                        'max_length': 50,
                    },
                    ('account_id',): {
                        'max_length': 50,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'customer_id':
                        (str,),
                    'account_id':
                        (str,),
                },
                'attribute_map': {
                    'customer_id': 'customer_id',
                    'account_id': 'account_id',
                },
                'location_map': {
                    'customer_id': 'path',
                    'account_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_account_endpoint = _Endpoint(
            settings={
                'response_type': (Account,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/customers/{customer_id}/accounts/{account_id}',
                'operation_id': 'get_account',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'customer_id',
                    'account_id',
                ],
                'required': [
                    'customer_id',
                    'account_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'customer_id',
                    'account_id',
                ]
            },
            root_map={
                'validations': {
                    ('customer_id',): {
                        'max_length': 50,
                    },
                    ('account_id',): {
                        'max_length': 50,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'customer_id':
                        (str,),
                    'account_id':
                        (str,),
                },
                'attribute_map': {
                    'customer_id': 'customer_id',
                    'account_id': 'account_id',
                },
                'location_map': {
                    'customer_id': 'path',
                    'account_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_accounts_endpoint = _Endpoint(
            settings={
                'response_type': (AccountPaginatedResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/customers/{customer_id}/accounts',
                'operation_id': 'get_accounts',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'customer_id',
                    'next_token',
                    'page_size',
                ],
                'required': [
                    'customer_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'customer_id',
                ]
            },
            root_map={
                'validations': {
                    ('customer_id',): {
                        'max_length': 50,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'customer_id':
                        (str,),
                    'next_token':
                        (str,),
                    'page_size':
                        (str,),
                },
                'attribute_map': {
                    'customer_id': 'customer_id',
                    'next_token': 'nextToken',
                    'page_size': 'pageSize',
                },
                'location_map': {
                    'customer_id': 'path',
                    'next_token': 'query',
                    'page_size': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.remove_aliases_endpoint = _Endpoint(
            settings={
                'response_type': (Account,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/customers/{customer_id}/accounts/{account_id}/remove_aliases',
                'operation_id': 'remove_aliases',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'customer_id',
                    'account_id',
                    'remove_account_aliases_request',
                ],
                'required': [
                    'customer_id',
                    'account_id',
                    'remove_account_aliases_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'customer_id',
                    'account_id',
                ]
            },
            root_map={
                'validations': {
                    ('customer_id',): {
                        'max_length': 50,
                    },
                    ('account_id',): {
                        'max_length': 50,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'customer_id':
                        (str,),
                    'account_id':
                        (str,),
                    'remove_account_aliases_request':
                        (RemoveAccountAliasesRequest,),
                },
                'attribute_map': {
                    'customer_id': 'customer_id',
                    'account_id': 'account_id',
                },
                'location_map': {
                    'customer_id': 'path',
                    'account_id': 'path',
                    'remove_account_aliases_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.update_account_endpoint = _Endpoint(
            settings={
                'response_type': (Account,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/customers/{customer_id}/accounts/{account_id}',
                'operation_id': 'update_account',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'customer_id',
                    'account_id',
                    'update_account_request',
                ],
                'required': [
                    'customer_id',
                    'account_id',
                    'update_account_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'customer_id',
                    'account_id',
                ]
            },
            root_map={
                'validations': {
                    ('customer_id',): {
                        'max_length': 50,
                    },
                    ('account_id',): {
                        'max_length': 50,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'customer_id':
                        (str,),
                    'account_id':
                        (str,),
                    'update_account_request':
                        (UpdateAccountRequest,),
                },
                'attribute_map': {
                    'customer_id': 'customer_id',
                    'account_id': 'account_id',
                },
                'location_map': {
                    'customer_id': 'path',
                    'account_id': 'path',
                    'update_account_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )

    def add_aliases(
        self,
        customer_id,
        account_id,
        add_account_aliases_request,
        **kwargs
    ):
        """Add Aliases to account  # noqa: E501

        Add Aliases to an account by id  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_aliases(customer_id, account_id, add_account_aliases_request, async_req=True)
        >>> result = thread.get()

        Args:
            customer_id (str):
            account_id (str):
            add_account_aliases_request (AddAccountAliasesRequest): Payload to add aliases to account

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Account
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['customer_id'] = \
            customer_id
        kwargs['account_id'] = \
            account_id
        kwargs['add_account_aliases_request'] = \
            add_account_aliases_request
        return self.add_aliases_endpoint.call_with_http_info(**kwargs)

    def associate_price_plan(
        self,
        customer_id,
        account_id,
        associate_price_plan_request,
        **kwargs
    ):
        """Associate a plan to an account  # noqa: E501

        Associate a plan to an account  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.associate_price_plan(customer_id, account_id, associate_price_plan_request, async_req=True)
        >>> result = thread.get()

        Args:
            customer_id (str):
            account_id (str):
            associate_price_plan_request (AssociatePricePlanRequest): Payload to associate a price plan to an account

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            AssociatePricePlanResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['customer_id'] = \
            customer_id
        kwargs['account_id'] = \
            account_id
        kwargs['associate_price_plan_request'] = \
            associate_price_plan_request
        return self.associate_price_plan_endpoint.call_with_http_info(**kwargs)

    def create_account(
        self,
        customer_id,
        create_account_request,
        **kwargs
    ):
        """Create an account  # noqa: E501

        Create an account  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_account(customer_id, create_account_request, async_req=True)
        >>> result = thread.get()

        Args:
            customer_id (str):
            create_account_request (CreateAccountRequest): Payload to create account

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Account
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['customer_id'] = \
            customer_id
        kwargs['create_account_request'] = \
            create_account_request
        return self.create_account_endpoint.call_with_http_info(**kwargs)

    def delete_account(
        self,
        customer_id,
        account_id,
        **kwargs
    ):
        """Delete an account  # noqa: E501

        Delete an account by id  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_account(customer_id, account_id, async_req=True)
        >>> result = thread.get()

        Args:
            customer_id (str):
            account_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            BaseSuccessResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['customer_id'] = \
            customer_id
        kwargs['account_id'] = \
            account_id
        return self.delete_account_endpoint.call_with_http_info(**kwargs)

    def get_account(
        self,
        customer_id,
        account_id,
        **kwargs
    ):
        """Get an account  # noqa: E501

        Get an account  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_account(customer_id, account_id, async_req=True)
        >>> result = thread.get()

        Args:
            customer_id (str):
            account_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Account
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['customer_id'] = \
            customer_id
        kwargs['account_id'] = \
            account_id
        return self.get_account_endpoint.call_with_http_info(**kwargs)

    def get_accounts(
        self,
        customer_id,
        **kwargs
    ):
        """List accounts of customer  # noqa: E501

        List accounts with pagination and sort  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_accounts(customer_id, async_req=True)
        >>> result = thread.get()

        Args:
            customer_id (str):

        Keyword Args:
            next_token (str): [optional]
            page_size (str): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            AccountPaginatedResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['customer_id'] = \
            customer_id
        return self.get_accounts_endpoint.call_with_http_info(**kwargs)

    def remove_aliases(
        self,
        customer_id,
        account_id,
        remove_account_aliases_request,
        **kwargs
    ):
        """Remove Aliases to account  # noqa: E501

        Remove Aliases to an account by id  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.remove_aliases(customer_id, account_id, remove_account_aliases_request, async_req=True)
        >>> result = thread.get()

        Args:
            customer_id (str):
            account_id (str):
            remove_account_aliases_request (RemoveAccountAliasesRequest): Payload to remove aliases from account

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Account
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['customer_id'] = \
            customer_id
        kwargs['account_id'] = \
            account_id
        kwargs['remove_account_aliases_request'] = \
            remove_account_aliases_request
        return self.remove_aliases_endpoint.call_with_http_info(**kwargs)

    def update_account(
        self,
        customer_id,
        account_id,
        update_account_request,
        **kwargs
    ):
        """Update an account  # noqa: E501

        Update an account by id  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_account(customer_id, account_id, update_account_request, async_req=True)
        >>> result = thread.get()

        Args:
            customer_id (str):
            account_id (str):
            update_account_request (UpdateAccountRequest): Payload to update account

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Account
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['customer_id'] = \
            customer_id
        kwargs['account_id'] = \
            account_id
        kwargs['update_account_request'] = \
            update_account_request
        return self.update_account_endpoint.call_with_http_info(**kwargs)

