# Generated by Django 3.2.13 on 2023-02-15 06:22

from django.db import migrations

def add_actions(apps, schema_editor):
    # GETTING EXISTING ACTIONS
    Action = apps.get_model('explorer', 'Action')
    queryset = Action.actions.all()
    action_names_exists = [query.name for query in queryset]
    
    # GETTING LIST OF ADDED ACTION
    added_actions = [
        'download',
        'delete',
        'upload'
    ]
    
    # ADDING ACTION TO DB
    for action in added_actions:
        if action in action_names_exists:
            continue
        Action.actions.create(name=action)
    
    return None


class Migration(migrations.Migration):

    dependencies = [
        ('explorer', '0005_rename_opertations_userrole_actions'),
    ]

    operations = [
        migrations.RunPython(add_actions),
    ]
