# jhc-cf-sdk-test
Common Fate API

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.0
- Package version: 1.0.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen
For more information, please visit [https://commonfate.io](https://commonfate.io)

## Requirements.

Python &gt;&#x3D;3.7

## Migration from other generators like python and python-legacy

### Changes
1. This generator uses spec case for all (object) property names and parameter names.
    - So if the spec has a property name like camelCase, it will use camelCase rather than camel_case
    - So you will need to update how you input and read properties to use spec case
2. Endpoint parameters are stored in dictionaries to prevent collisions (explanation below)
    - So you will need to update how you pass data in to endpoints
3. Endpoint responses now include the original response, the deserialized response body, and (todo)the deserialized headers
    - So you will need to update your code to use response.body to access deserialized data
4. All validated data is instantiated in an instance that subclasses all validated Schema classes and Decimal/str/list/tuple/frozendict/NoneClass/BoolClass/bytes/io.FileIO
    - This means that you can use isinstance to check if a payload validated against a schema class
    - This means that no data will be of type None/True/False
        - ingested None will subclass NoneClass
        - ingested True will subclass BoolClass
        - ingested False will subclass BoolClass
        - So if you need to check is True/False/None, instead use instance.is_true_oapg()/.is_false_oapg()/.is_none_oapg()
5. All validated class instances are immutable except for ones based on io.File
    - This is because if properties were changed after validation, that validation would no longer apply
    - So no changing values or property values after a class has been instantiated
6. String + Number types with formats
    - String type data is stored as a string and if you need to access types based on its format like date,
    date-time, uuid, number etc then you will need to use accessor functions on the instance
    - type string + format: See .as_date_oapg, .as_datetime_oapg, .as_decimal_oapg, .as_uuid_oapg
    - type number + format: See .as_float_oapg, .as_int_oapg
    - this was done because openapi/json-schema defines constraints. string data may be type string with no format
    keyword in one schema, and include a format constraint in another schema
    - So if you need to access a string format based type, use as_date_oapg/as_datetime_oapg/as_decimal_oapg/as_uuid_oapg
    - So if you need to access a number format based type, use as_int_oapg/as_float_oapg
7. Property access on AnyType(type unset) or object(dict) schemas
    - Only required keys with valid python names are properties like .someProp and have type hints
    - All optional keys may not exist, so properties are not defined for them
    - One can access optional values with dict_instance['optionalProp'] and KeyError will be raised if it does not exist
    - Use get_item_oapg if you need a way to always get a value whether or not the key exists
        - If the key does not exist, schemas.unset is returned from calling dict_instance.get_item_oapg('optionalProp')
        - All required and optional keys have type hints for this method, and @typing.overload is used
        - A type hint is also generated for additionalProperties accessed using this method
    - So you will need to update you code to use some_instance['optionalProp'] to access optional property
    and additionalProperty values
8. The location of the api classes has changed
    - Api classes are located in your_package.apis.tags.some_api
    - This change was made to eliminate redundant code generation
    - Legacy generators generated the same endpoint twice if it had > 1 tag on it
    - This generator defines an endpoint in one class, then inherits that class to generate
      apis by tags and by paths
    - This change reduces code and allows quicker run time if you use the path apis
        - path apis are at your_package.apis.paths.some_path
    - Those apis will only load their needed models, which is less to load than all of the resources needed in a tag api
    - So you will need to update your import paths to the api classes

### Why are Oapg and _oapg used in class and method names?
Classes can have arbitrarily named properties set on them
Endpoints can have arbitrary operationId method names set
For those reasons, I use the prefix Oapg and _oapg to greatly reduce the likelihood of collisions
on protected + public classes/methods.
oapg stands for OpenApi Python Generator.

### Object property spec case
This was done because when payloads are ingested, they can be validated against N number of schemas.
If the input signature used a different property name then that has mutated the payload.
So SchemaA and SchemaB must both see the camelCase spec named variable.
Also it is possible to send in two properties, named camelCase and camel_case in the same payload.
That use case should be support so spec case is used.

### Parameter spec case
Parameters can be included in different locations including:
- query
- path
- header
- cookie

Any of those parameters could use the same parameter names, so if every parameter
was included as an endpoint parameter in a function signature, they would collide.
For that reason, each of those inputs have been separated out into separate typed dictionaries:
- query_params
- path_params
- header_params
- cookie_params

So when updating your code, you will need to pass endpoint parameters in using those
dictionaries.

### Endpoint responses
Endpoint responses have been enriched to now include more information.
Any response reom an endpoint will now include the following properties:
response: urllib3.HTTPResponse
body: typing.Union[Unset, Schema]
headers: typing.Union[Unset, TODO]
Note: response header deserialization has not yet been added


## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import jhc_cf_sdk_test
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import jhc_cf_sdk_test
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import jhc_cf_sdk_test
from pprint import pprint
from jhc_cf_sdk_test.apis.tags import admin_api
from jhc_cf_sdk_test.model.access_rule_detail import AccessRuleDetail
from jhc_cf_sdk_test.model.approver_config import ApproverConfig
from jhc_cf_sdk_test.model.arg_schema import ArgSchema
from jhc_cf_sdk_test.model.create_access_rule_target import CreateAccessRuleTarget
from jhc_cf_sdk_test.model.group import Group
from jhc_cf_sdk_test.model.groups import Groups
from jhc_cf_sdk_test.model.option import Option
from jhc_cf_sdk_test.model.provider import Provider
from jhc_cf_sdk_test.model.provider_setup import ProviderSetup
from jhc_cf_sdk_test.model.provider_setup_instructions import ProviderSetupInstructions
from jhc_cf_sdk_test.model.request import Request
from jhc_cf_sdk_test.model.time_constraints import TimeConstraints
from jhc_cf_sdk_test.model.user import User
# Defining the host is optional and defaults to http://localhost:8080
# See configuration.py for a list of all supported configuration parameters.
configuration = jhc_cf_sdk_test.Configuration(
    host = "http://localhost:8080"
)


# Enter a context with an instance of the API client
with jhc_cf_sdk_test.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = admin_api.AdminApi(api_client)
    rule_id = "ruleId_example" # str | 

    try:
        # Archive Access Rule
        api_response = api_instance.admin_archive_access_rule(rule_id)
        pprint(api_response)
    except jhc_cf_sdk_test.ApiException as e:
        print("Exception when calling AdminApi->admin_archive_access_rule: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost:8080*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AdminApi* | [**admin_archive_access_rule**](docs/apis/tags/AdminApi.md#admin_archive_access_rule) | **post** /api/v1/admin/access-rules/{ruleId}/archive | Archive Access Rule
*AdminApi* | [**admin_complete_providersetup**](docs/apis/tags/AdminApi.md#admin_complete_providersetup) | **post** /api/v1/admin/providersetups/{providersetupId}/complete | Complete a ProviderSetup
*AdminApi* | [**admin_create_access_rule**](docs/apis/tags/AdminApi.md#admin_create_access_rule) | **post** /api/v1/admin/access-rules | Create Access Rule
*AdminApi* | [**admin_create_group**](docs/apis/tags/AdminApi.md#admin_create_group) | **post** /api/v1/admin/groups | Create Group
*AdminApi* | [**admin_create_providersetup**](docs/apis/tags/AdminApi.md#admin_create_providersetup) | **post** /api/v1/admin/providersetups | Begin the setup process for a new Access Provider
*AdminApi* | [**admin_create_user**](docs/apis/tags/AdminApi.md#admin_create_user) | **post** /api/v1/admin/users | Create User
*AdminApi* | [**admin_delete_group**](docs/apis/tags/AdminApi.md#admin_delete_group) | **delete** /api/v1/admin/groups/{groupId} | Delete Group
*AdminApi* | [**admin_delete_providersetup**](docs/apis/tags/AdminApi.md#admin_delete_providersetup) | **delete** /api/v1/admin/providersetups/{providersetupId} | Delete an in-progress provider setup
*AdminApi* | [**admin_get_access_rule**](docs/apis/tags/AdminApi.md#admin_get_access_rule) | **get** /api/v1/admin/access-rules/{ruleId} | Get Access Rule
*AdminApi* | [**admin_get_access_rule_version**](docs/apis/tags/AdminApi.md#admin_get_access_rule_version) | **get** /api/v1/admin/access-rules/{ruleId}/versions/{version} | Get Access Rule Version
*AdminApi* | [**admin_get_access_rule_versions**](docs/apis/tags/AdminApi.md#admin_get_access_rule_versions) | **get** /api/v1/admin/access-rules/{ruleId}/versions | Get Access Rule version history
*AdminApi* | [**admin_get_deployment_version**](docs/apis/tags/AdminApi.md#admin_get_deployment_version) | **get** /api/v1/admin/deployment/version | Get deployment version details
*AdminApi* | [**admin_get_group**](docs/apis/tags/AdminApi.md#admin_get_group) | **get** /api/v1/admin/groups/{groupId} | Get Group Details
*AdminApi* | [**admin_get_identity_configuration**](docs/apis/tags/AdminApi.md#admin_get_identity_configuration) | **get** /api/v1/admin/identity | Get identity configuration
*AdminApi* | [**admin_get_provider**](docs/apis/tags/AdminApi.md#admin_get_provider) | **get** /api/v1/admin/providers/{providerId} | List providers
*AdminApi* | [**admin_get_provider_args**](docs/apis/tags/AdminApi.md#admin_get_provider_args) | **get** /api/v1/admin/providers/{providerId}/args | Get provider arg schema
*AdminApi* | [**admin_get_providersetup**](docs/apis/tags/AdminApi.md#admin_get_providersetup) | **get** /api/v1/admin/providersetups/{providersetupId} | Get an in-progress provider setup
*AdminApi* | [**admin_get_providersetup_instructions**](docs/apis/tags/AdminApi.md#admin_get_providersetup_instructions) | **get** /api/v1/admin/providersetups/{providersetupId}/instructions | Get the setup instructions for an Access Provider
*AdminApi* | [**admin_list_access_rules**](docs/apis/tags/AdminApi.md#admin_list_access_rules) | **get** /api/v1/admin/access-rules | List Access Rules
*AdminApi* | [**admin_list_groups**](docs/apis/tags/AdminApi.md#admin_list_groups) | **get** /api/v1/admin/groups | List groups
*AdminApi* | [**admin_list_provider_arg_options**](docs/apis/tags/AdminApi.md#admin_list_provider_arg_options) | **get** /api/v1/admin/providers/{providerId}/args/{argId}/options | List provider arg options
*AdminApi* | [**admin_list_providers**](docs/apis/tags/AdminApi.md#admin_list_providers) | **get** /api/v1/admin/providers | List providers
*AdminApi* | [**admin_list_providersetups**](docs/apis/tags/AdminApi.md#admin_list_providersetups) | **get** /api/v1/admin/providersetups | List the provider setups in progress
*AdminApi* | [**admin_list_requests**](docs/apis/tags/AdminApi.md#admin_list_requests) | **get** /api/v1/admin/requests | Your GET endpoint
*AdminApi* | [**admin_list_users**](docs/apis/tags/AdminApi.md#admin_list_users) | **get** /api/v1/admin/users | Returns a list of users
*AdminApi* | [**admin_submit_providersetup_step**](docs/apis/tags/AdminApi.md#admin_submit_providersetup_step) | **put** /api/v1/admin/providersetups/{providersetupId}/steps/{stepIndex}/complete | Update the completion status for a Provider setup step
*AdminApi* | [**admin_sync_identity**](docs/apis/tags/AdminApi.md#admin_sync_identity) | **post** /api/v1/admin/identity/sync | Sync Identity
*AdminApi* | [**admin_update_access_rule**](docs/apis/tags/AdminApi.md#admin_update_access_rule) | **put** /api/v1/admin/access-rules/{ruleId} | Update Access Rule
*AdminApi* | [**admin_update_group**](docs/apis/tags/AdminApi.md#admin_update_group) | **put** /api/v1/admin/groups/{groupId} | Update Group
*AdminApi* | [**admin_update_user**](docs/apis/tags/AdminApi.md#admin_update_user) | **post** /api/v1/admin/users/{userId} | Update User
*AdminApi* | [**admin_validate_providersetup**](docs/apis/tags/AdminApi.md#admin_validate_providersetup) | **post** /api/v1/admin/providersetups/{providersetupId}/validate | Validate the configuration for a Provider Setup
*EndUserApi* | [**admin_get_request**](docs/apis/tags/EndUserApi.md#admin_get_request) | **get** /api/v1/admin/requests/{requestId} | Get a request
*EndUserApi* | [**user_cancel_request**](docs/apis/tags/EndUserApi.md#user_cancel_request) | **post** /api/v1/requests/{requestId}/cancel | Cancel a request
*EndUserApi* | [**user_create_favorite**](docs/apis/tags/EndUserApi.md#user_create_favorite) | **post** /api/v1/favorites | Create Favorite
*EndUserApi* | [**user_create_request**](docs/apis/tags/EndUserApi.md#user_create_request) | **post** /api/v1/requests | Create a request
*EndUserApi* | [**user_delete_favorite**](docs/apis/tags/EndUserApi.md#user_delete_favorite) | **delete** /api/v1/favorites/{id} | 
*EndUserApi* | [**user_get_access_instructions**](docs/apis/tags/EndUserApi.md#user_get_access_instructions) | **get** /api/v1/requests/{requestId}/access-instructions | Get Access Instructions
*EndUserApi* | [**user_get_access_rule**](docs/apis/tags/EndUserApi.md#user_get_access_rule) | **get** /api/v1/access-rules/{ruleId} | Get Access Rule
*EndUserApi* | [**user_get_access_rule_approvers**](docs/apis/tags/EndUserApi.md#user_get_access_rule_approvers) | **get** /api/v1/access-rules/{ruleId}/approvers | List Access Rule approvers
*EndUserApi* | [**user_get_access_token**](docs/apis/tags/EndUserApi.md#user_get_access_token) | **get** /api/v1/requests/{requestId}/access-token | Get Access Token
*EndUserApi* | [**user_get_favorite**](docs/apis/tags/EndUserApi.md#user_get_favorite) | **get** /api/v1/favorites/{id} | Get Favorite
*EndUserApi* | [**user_get_me**](docs/apis/tags/EndUserApi.md#user_get_me) | **get** /api/v1/users/me | Get details for the current user
*EndUserApi* | [**user_get_request**](docs/apis/tags/EndUserApi.md#user_get_request) | **get** /api/v1/requests/{requestId} | Get a request
*EndUserApi* | [**user_get_user**](docs/apis/tags/EndUserApi.md#user_get_user) | **get** /api/v1/users/{userId} | Get a user
*EndUserApi* | [**user_list_access_rules**](docs/apis/tags/EndUserApi.md#user_list_access_rules) | **get** /api/v1/access-rules | List Access Rules
*EndUserApi* | [**user_list_favorites**](docs/apis/tags/EndUserApi.md#user_list_favorites) | **get** /api/v1/favorites | ListFavorites
*EndUserApi* | [**user_list_request_events**](docs/apis/tags/EndUserApi.md#user_list_request_events) | **get** /api/v1/requests/{requestId}/events | List request events
*EndUserApi* | [**user_list_requests**](docs/apis/tags/EndUserApi.md#user_list_requests) | **get** /api/v1/requests | List my requests
*EndUserApi* | [**user_list_requests_past**](docs/apis/tags/EndUserApi.md#user_list_requests_past) | **get** /api/v1/requests/past | Your GET endpoint
*EndUserApi* | [**user_list_requests_upcoming**](docs/apis/tags/EndUserApi.md#user_list_requests_upcoming) | **get** /api/v1/requests/upcoming | Your GET endpoint
*EndUserApi* | [**user_lookup_access_rule**](docs/apis/tags/EndUserApi.md#user_lookup_access_rule) | **get** /api/v1/access-rules/lookup | Lookup an access rule based on the target
*EndUserApi* | [**user_review_request**](docs/apis/tags/EndUserApi.md#user_review_request) | **post** /api/v1/requests/{requestId}/review | Review a request
*EndUserApi* | [**user_revoke_request**](docs/apis/tags/EndUserApi.md#user_revoke_request) | **post** /api/v1/requests/{requestid}/revoke | Revoke an active request
*EndUserApi* | [**user_update_favorite**](docs/apis/tags/EndUserApi.md#user_update_favorite) | **put** /api/v1/favorites/{id} | 

## Documentation For Models

 - [AccessInstructions](docs/models/AccessInstructions.md)
 - [AccessRule](docs/models/AccessRule.md)
 - [AccessRuleDetail](docs/models/AccessRuleDetail.md)
 - [AccessRuleMetadata](docs/models/AccessRuleMetadata.md)
 - [AccessRuleStatus](docs/models/AccessRuleStatus.md)
 - [AccessRuleTarget](docs/models/AccessRuleTarget.md)
 - [AccessRuleTargetDetail](docs/models/AccessRuleTargetDetail.md)
 - [AccessRuleTargetDetailArguments](docs/models/AccessRuleTargetDetailArguments.md)
 - [ApprovalMethod](docs/models/ApprovalMethod.md)
 - [ApproverConfig](docs/models/ApproverConfig.md)
 - [ArgSchema](docs/models/ArgSchema.md)
 - [Argument](docs/models/Argument.md)
 - [CreateAccessRuleTarget](docs/models/CreateAccessRuleTarget.md)
 - [CreateAccessRuleTargetDetailArguments](docs/models/CreateAccessRuleTargetDetailArguments.md)
 - [CreateRequestWith](docs/models/CreateRequestWith.md)
 - [CreateRequestWithSubRequest](docs/models/CreateRequestWithSubRequest.md)
 - [Favorite](docs/models/Favorite.md)
 - [FavoriteDetail](docs/models/FavoriteDetail.md)
 - [Grant](docs/models/Grant.md)
 - [Group](docs/models/Group.md)
 - [Group1](docs/models/Group1.md)
 - [Groups](docs/models/Groups.md)
 - [IdpStatus](docs/models/IdpStatus.md)
 - [KeyValue](docs/models/KeyValue.md)
 - [Log](docs/models/Log.md)
 - [LookupAccessRule](docs/models/LookupAccessRule.md)
 - [ModelWith](docs/models/ModelWith.md)
 - [Option](docs/models/Option.md)
 - [Provider](docs/models/Provider.md)
 - [ProviderConfigField](docs/models/ProviderConfigField.md)
 - [ProviderConfigValidation](docs/models/ProviderConfigValidation.md)
 - [ProviderConfigValue](docs/models/ProviderConfigValue.md)
 - [ProviderSetup](docs/models/ProviderSetup.md)
 - [ProviderSetupDiagnosticLog](docs/models/ProviderSetupDiagnosticLog.md)
 - [ProviderSetupInstructions](docs/models/ProviderSetupInstructions.md)
 - [ProviderSetupStepDetails](docs/models/ProviderSetupStepDetails.md)
 - [ProviderSetupStepOverview](docs/models/ProviderSetupStepOverview.md)
 - [ProviderSetupValidation](docs/models/ProviderSetupValidation.md)
 - [Request](docs/models/Request.md)
 - [RequestAccessRule](docs/models/RequestAccessRule.md)
 - [RequestAccessRuleTarget](docs/models/RequestAccessRuleTarget.md)
 - [RequestArgument](docs/models/RequestArgument.md)
 - [RequestDetail](docs/models/RequestDetail.md)
 - [RequestEvent](docs/models/RequestEvent.md)
 - [RequestStatus](docs/models/RequestStatus.md)
 - [RequestTiming](docs/models/RequestTiming.md)
 - [ReviewDecision](docs/models/ReviewDecision.md)
 - [TimeConstraints](docs/models/TimeConstraints.md)
 - [User](docs/models/User.md)
 - [WithOption](docs/models/WithOption.md)

## Documentation For Authorization

 All endpoints do not require authorization.

## Author




## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in jhc_cf_sdk_test.apis and jhc_cf_sdk_test.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from jhc_cf_sdk_test.apis.default_api import DefaultApi`
- `from jhc_cf_sdk_test.model.pet import Pet`

Solution 1:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import jhc_cf_sdk_test
from jhc_cf_sdk_test.apis import *
from jhc_cf_sdk_test.models import *
```
