import os


def create_new_project(name):
    result = INITIAL_PROJECT.copy()
    result['settings']['ADMIN_SITE_HEADER'] = name
    result['settings']['EMAIL_SUBJECT_PREFIX'] = '[{}] '.format(name)

    if os.environ.get('PROTOTYPER_DEV') == 'yes':
        result['apps'].extend(DEMO_APPS)

    for app, models in INITIAL_DJANGO_APPS:
        result['apps'].append({
            'name': app.split('.')[-1],
            'external': True,
            'models': [{'name': m, 'fields': [], 'admin': {'generate': False}} for m in models]
        })

    return result


INITIAL_DJANGO_APPS = [
    ('django.contrib.admin', ['LogEntry']),
    ('django.contrib.auth', ['AbstractBaseUser', 'AbstractUser', 'Group', 'Permission', 'PermissionsMixin', 'User']),
    ('django.contrib.contenttypes', ['ContentType']),
    ('django.contrib.sessions', ['AbstractBaseSession', 'Session']),
    ('django.contrib.messages', []),
    ('django.contrib.staticfiles', []),
]

INITIAL_PROJECT = {
    'version': '0.1',
    'build_settings': {},
    'settings': {
        'ADMIN_SITE_HEADER': 'project1',
        'DEFAULT_FROM_EMAIL': 'noreply@site.com',
        'EMAIL_SUBJECT_PREFIX': '[project1] ',
        'LANGUAGE_CODE': 'en-us',
        'TIME_ZONE': 'Europe/Brussels',
        'USE_I18N': True,
        'USE_L10N': True,
    },
    'name': 'project1',
    'ui': {'models_view': 'designer'},
    'plugins': [],
    'apps': [],
}

DEMO_APPS = [
    {'models': [
        {'admin': {'generate': True},
         'fields': [{'attrs': {'max_length': '10'},
                     'name': 'title',
                     'relation': None,
                     'type': 'CharField'},
                    {'attrs': {},
                     'name': 'slug',
                     'relation': None,
                     'type': 'SlugField'}],
         'name': 'Category',
         'ui_left': 20,
         'ui_top': 20},
        {'admin': {'generate': True},
         'fields': [{'attrs': {},
                     'name': 'title',
                     'relation': None,
                     'type': 'CharField'},
                    {'attrs': {},
                     'name': 'slug',
                     'relation': None,
                     'type': 'SlugField'},
                    {'attrs': {},
                     'name': 'categories',
                     'relation': 'products.Category',
                     'type': 'ManyToManyField'},
                    {'attrs': {},
                     'name': 'description',
                     'relation': None,
                     'type': 'TextField'},
                    {'attrs': {'decimal_places': '2',
                               'max_digits': '10'},
                     'name': 'price',
                     'relation': None,
                     'type': 'DecimalField'}],
         'name': 'Product',
         'ui_left': 20,
         'ui_top': 104},
        {'admin': {'generate': True},
         'fields': [{'attrs': {},
                     'name': 'product',
                     'relation': 'products.Product',
                     'type': 'ForeignKey'},
                    {'attrs': {'upload_to': 'products/images/'},
                     'name': 'image',
                     'relation': None,
                     'type': 'ImageField'}],
         'name': 'Image',
         'ui_left': 20,
         'ui_top': 264}],
        'name': 'products',
        'ui_color': '#9AAF90',
        'external': False},
    {'models': [{'admin': {'generate': True},
                 'fields': [{'attrs': {},
                             'name': 'number',
                             'relation': None,
                             'type': 'CharField'},
                            {'attrs': {},
                             'name': 'timestamp',
                             'relation': None,
                             'type': 'DateTimeField'},
                            {'attrs': {'decimal_places': '2',
                                       'max_digits': '10'},
                             'name': 'total_amount',
                             'relation': None,
                             'type': 'DecimalField'}],
                 'name': 'Order',
                 'ui_left': 200,
                 'ui_top': 20},
                {'admin': {'generate': True},
                 'fields': [{'attrs': {},
                             'name': 'order',
                             'relation': 'orders.Order',
                             'type': 'ForeignKey'},
                            {'attrs': {},
                             'name': 'product',
                             'relation': 'products.Product',
                             'type': 'ForeignKey'},
                            {'attrs': {'decimal_places': '2',
                                       'max_digits': '10'},
                             'name': 'price',
                             'relation': None,
                             'type': 'DecimalField'},
                            {'attrs': {},
                             'name': 'quantity',
                             'relation': None,
                             'type': 'PositiveSmallIntegerField'}],
                 'name': 'OrderItem',
                 'ui_left': 200,
                 'ui_top': 140}],
     'name': 'orders',
     'ui_color': '#F77A5E',
     'external': False},
    {'models': [{'admin': {'generate': True},
                 'fields': [{'attrs': {},
                             'name': 'title',
                             'relation': None,
                             'type': 'CharField'},
                            {'attrs': {},
                             'name': 'slug',
                             'relation': None,
                             'type': 'SlugField'},
                            {'attrs': {},
                             'name': 'publication_date',
                             'relation': None,
                             'type': 'DateTimeField'},
                            {'attrs': {},
                             'name': 'text',
                             'relation': None,
                             'type': 'TextField'}],
                 'name': 'News',
                 'ui_left': 480,
                 'ui_top': 20}],
     'name': 'news',
     'ui_color': '#DAC9B7',
     'external': False},
    {'models': [{'admin': {'generate': True},
                 'fields': [
                            {'attrs': {},
                             'name': 'big_integer',
                             'relation': None,
                             'type': 'BigIntegerField'},
                            {'attrs': {},
                             'name': 'binary',
                             'relation': None,
                             'type': 'BinaryField'},
                            {'attrs': {},
                             'name': 'boolean',
                             'relation': None,
                             'type': 'BooleanField'},
                            {'attrs': {},
                             'name': 'char',
                             'relation': None,
                             'type': 'CharField'},
                            {'attrs': {},
                             'name': 'date',
                             'relation': None,
                             'type': 'DateField'},
                            {'attrs': {},
                             'name': 'date_time',
                             'relation': None,
                             'type': 'DateTimeField'},
                            {'attrs': {'max_digits': 5, 'decimal_places': 2},
                             'name': 'decimal',
                             'relation': None,
                             'type': 'DecimalField'},
                            {'attrs': {},
                             'name': 'duration',
                             'relation': None,
                             'type': 'DurationField'},
                            {'attrs': {},
                             'name': 'email',
                             'relation': None,
                             'type': 'EmailField'},
                            {'attrs': {'upload_to': 'products/images/'},
                             'name': 'file',
                             'relation': None,
                             'type': 'FileField'},
                            {'attrs': {},
                             'name': 'file_path',
                             'relation': None,
                             'type': 'FilePathField'},
                            {'attrs': {},
                             'name': 'float',
                             'relation': None,
                             'type': 'FloatField'},
                            {'attrs': {},
                             'name': 'foreign_key',
                             'relation': 'products.Product',
                             'type': 'ForeignKey'},
                            {'attrs': {},
                             'name': 'generic_ipaddr',
                             'relation': None,
                             'type': 'GenericIPAddressField'},
                            {'attrs': {'upload_to': 'products/images/'},
                             'name': 'image',
                             'relation': None,
                             'type': 'ImageField'},
                            {'attrs': {},
                             'name': 'integer',
                             'relation': None,
                             'type': 'IntegerField'},
                            {'attrs': {},
                             'name': 'many_to_many',
                             'relation': 'news.News',
                             'type': 'ManyToManyField'},
                            {'attrs': {},
                             'name': 'null_boolean',
                             'relation': None,
                             'type': 'NullBooleanField'},
                            {'attrs': {},
                             'name': 'one_to_one',
                             'relation': 'orders.Order',
                             'type': 'OneToOneField'},
                            {'attrs': {},
                             'name': 'positive_integer',
                             'relation': None,
                             'type': 'PositiveIntegerField'},
                            {'attrs': {},
                             'name': 'positive_small_int',
                             'relation': None,
                             'type': 'PositiveSmallIntegerField'},
                            {'attrs': {},
                             'name': 'slug',
                             'relation': None,
                             'type': 'SlugField'},
                            {'attrs': {},
                             'name': 'small_integer',
                             'relation': None,
                             'type': 'SmallIntegerField'},
                            {'attrs': {},
                             'name': 'text',
                             'relation': None,
                             'type': 'TextField'},
                            {'attrs': {},
                             'name': 'time',
                             'relation': None,
                             'type': 'TimeField'},
                            {'attrs': {},
                             'name': 'url',
                             'relation': None,
                             'type': 'URLField'},
                            {'attrs': {},
                             'name': 'uuid',
                             'relation': None,
                             'type': 'UUIDField'}],
                 'name': 'AllFields',
                 'ui_left': 480,
                 'ui_top': 160}],
     'name': 'temp',
     'ui_color': '#9CC4E4',
     'external': False},
]
