from ..base import BuildStage
from pathlib import Path


TPL = """\"\"\"
Django settings for {project_name} project.

Generated by 'django-admin startproject' using Django 2.0.

For more information on this file, see
https://docs.djangoproject.com/en/2.0/topics/settings/

For the full list of settings and their values, see
https://docs.djangoproject.com/en/2.0/ref/settings/
\"\"\"

import os

# Build paths inside the project like this: os.path.join(BASE_DIR, ...)
BASE_DIR = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))


# Quick-start development settings - unsuitable for production
# See https://docs.djangoproject.com/en/2.0/howto/deployment/checklist/

# SECURITY WARNING: keep the secret key used in production secret!
SECRET_KEY = '{SECRET_KEY}'

# SECURITY WARNING: don't run with debug turned on in production!
DEBUG = True

ALLOWED_HOSTS = []


# Application definition

INSTALLED_APPS = [
    {INSTALLED_APPS}
]

MIDDLEWARE = [
    'django.middleware.security.SecurityMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.middleware.common.CommonMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    'django.middleware.clickjacking.XFrameOptionsMiddleware',
]

ROOT_URLCONF = '{url_conf}'

TEMPLATES = [
    {{
        'BACKEND': 'django.template.backends.django.DjangoTemplates',
        'DIRS': [],
        'APP_DIRS': True,
        'OPTIONS': {{
            'context_processors': [
                'django.template.context_processors.debug',
                'django.template.context_processors.request',
                'django.contrib.auth.context_processors.auth',
                'django.contrib.messages.context_processors.messages',
            ],
        }},
    }},
]

WSGI_APPLICATION = '{wsgi_app}'


# Database
# https://docs.djangoproject.com/en/2.0/ref/settings/#databases

DATABASES = {{
    'default': {{
        'ENGINE': 'django.db.backends.sqlite3',
        'NAME': os.path.join(BASE_DIR, 'db.sqlite3'),
    }}
}}


# Password validation
# https://docs.djangoproject.com/en/2.0/ref/settings/#auth-password-validators

AUTH_PASSWORD_VALIDATORS = [
    {{
        'NAME': 'django.contrib.auth.password_validation.UserAttributeSimilarityValidator',
    }},
    {{
        'NAME': 'django.contrib.auth.password_validation.MinimumLengthValidator',
    }},
    {{
        'NAME': 'django.contrib.auth.password_validation.CommonPasswordValidator',
    }},
    {{
        'NAME': 'django.contrib.auth.password_validation.NumericPasswordValidator',
    }},
]


# Internationalization
# https://docs.djangoproject.com/en/2.0/topics/i18n/

LANGUAGE_CODE = 'en-us'

TIME_ZONE = 'UTC'

USE_I18N = True

USE_L10N = True

USE_TZ = True


# Static files (CSS, JavaScript, Images)
# https://docs.djangoproject.com/en/2.0/howto/static-files/

STATIC_URL = '/static/'
"""


class SettingsStage(BuildStage):
    def run(self):
        root = Path(self.build.settings_pckg_path)
        root.mkdir()
        (root / '__init__.py').touch()
        settings_py = root / 'settings.py'
        content = self._get_content()
        settings_py.write_text(content)
    
    def _get_content(self):
        proj_name = self.build.project.name
        ctx = {
            'project_name': proj_name,
            'SECRET_KEY': '=8od22*=9b5d8kd!pu_tq62l3&o5@xm_l0@1uw6y&h)r==$@lu',
            'url_conf': '{}.urls'.format(proj_name),
            'wsgi_app': '{}.wsgi.application'.format(proj_name),
            'INSTALLED_APPS': self._installed_apps_lines()
        }
        result = TPL.format(**ctx)
        return result
    
    def _installed_apps_lines(self):
        result = [
            "'django.contrib.admin',",
            "'django.contrib.auth',",
            "'django.contrib.contenttypes',",
            "'django.contrib.sessions',",
            "'django.contrib.messages',",
            "'django.contrib.staticfiles',",
            "",
        ]
        for app in self.build.details['apps']:
            if not app['external']:
                result.append("'{}',".format(app['name']))
        return '\n    '.join(result)
