"""initial schema

Revision ID: 806f5dcb11bf
Revises:
Create Date: 2020-05-01 10:10:30.843894

"""
import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "806f5dcb11bf"
down_revision = None
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "redun_version",
        sa.Column("id", sa.String(), nullable=False),
        sa.Column("version", sa.Integer(), nullable=False),
        sa.Column("timestamp", sa.DateTime(), nullable=False),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_table(
        "task",
        sa.Column("hash", sa.String(length=40), nullable=False),
        sa.Column("name", sa.String(), nullable=False),
        sa.Column("namespace", sa.String(), nullable=False),
        sa.Column("source", sa.String(), nullable=False),
        sa.PrimaryKeyConstraint("hash"),
    )
    op.create_table(
        "value",
        sa.Column("value_hash", sa.String(length=40), nullable=False),
        sa.Column("type", sa.String(length=100), nullable=False),
        sa.Column("format", sa.String(length=100), nullable=False),
        sa.Column("value", sa.LargeBinary(), nullable=False),
        sa.PrimaryKeyConstraint("value_hash"),
    )
    op.create_table(
        "call_node",
        sa.Column("call_hash", sa.String(length=40), nullable=False),
        sa.Column("task_name", sa.String(length=1024), nullable=False),
        sa.Column("task_hash", sa.String(length=40), nullable=False),
        sa.Column("args_hash", sa.String(length=40), nullable=False),
        sa.Column("value_hash", sa.String(length=40), nullable=False),
        sa.Column("timestamp", sa.DateTime(), nullable=False),
        sa.ForeignKeyConstraint(
            ["task_hash"],
            ["task.hash"],
        ),
        sa.ForeignKeyConstraint(
            ["value_hash"],
            ["value.value_hash"],
        ),
        sa.PrimaryKeyConstraint("call_hash"),
    )
    op.create_index(op.f("ix_call_node_task_hash"), "call_node", ["task_hash"], unique=False)
    op.create_index(op.f("ix_call_node_value_hash"), "call_node", ["value_hash"], unique=False)
    op.create_table(
        "file",
        sa.Column("value_hash", sa.String(length=40), nullable=False),
        sa.Column("path", sa.String(length=1024), nullable=False),
        sa.ForeignKeyConstraint(
            ["value_hash"],
            ["value.value_hash"],
        ),
        sa.PrimaryKeyConstraint("value_hash"),
    )
    op.create_table(
        "handle",
        sa.Column("hash", sa.String(length=40), nullable=False),
        sa.Column("fullname", sa.String(length=1024), nullable=False),
        sa.Column("value_hash", sa.String(length=40), nullable=False),
        sa.Column("key", sa.String(length=1024), nullable=False),
        sa.Column("is_valid", sa.Boolean(), nullable=False),
        sa.ForeignKeyConstraint(
            ["value_hash"],
            ["value.value_hash"],
        ),
        sa.PrimaryKeyConstraint("hash"),
    )
    op.create_index(op.f("ix_handle_fullname"), "handle", ["fullname"], unique=False)
    op.create_index(op.f("ix_handle_value_hash"), "handle", ["value_hash"], unique=False)
    op.create_table(
        "subvalue",
        sa.Column("value_hash", sa.String(length=40), nullable=False),
        sa.Column("parent_value_hash", sa.String(length=40), nullable=False),
        sa.ForeignKeyConstraint(
            ["parent_value_hash"],
            ["value.value_hash"],
        ),
        sa.ForeignKeyConstraint(
            ["value_hash"],
            ["value.value_hash"],
        ),
        sa.PrimaryKeyConstraint("value_hash", "parent_value_hash"),
    )
    op.create_index(
        op.f("ix_subvalue_parent_value_hash"), "subvalue", ["parent_value_hash"], unique=False
    )
    op.create_index(op.f("ix_subvalue_value_hash"), "subvalue", ["value_hash"], unique=False)
    op.create_table(
        "argument",
        sa.Column("arg_hash", sa.String(length=40), nullable=False),
        sa.Column("call_hash", sa.String(length=40), nullable=False),
        sa.Column("value_hash", sa.String(length=40), nullable=False),
        sa.Column("arg_position", sa.Integer(), nullable=True),
        sa.Column("arg_key", sa.String(length=100), nullable=True),
        sa.ForeignKeyConstraint(
            ["call_hash"],
            ["call_node.call_hash"],
        ),
        sa.ForeignKeyConstraint(
            ["value_hash"],
            ["value.value_hash"],
        ),
        sa.PrimaryKeyConstraint("arg_hash"),
    )
    op.create_index(op.f("ix_argument_call_hash"), "argument", ["call_hash"], unique=False)
    op.create_index(op.f("ix_argument_value_hash"), "argument", ["value_hash"], unique=False)
    op.create_table(
        "call_edge",
        sa.Column("parent_id", sa.String(length=40), nullable=False),
        sa.Column("child_id", sa.String(length=40), nullable=False),
        sa.Column("call_order", sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(
            ["child_id"],
            ["call_node.call_hash"],
        ),
        sa.ForeignKeyConstraint(
            ["parent_id"],
            ["call_node.call_hash"],
        ),
        sa.PrimaryKeyConstraint("parent_id", "child_id", "call_order"),
    )
    op.create_index(op.f("ix_call_edge_child_id"), "call_edge", ["child_id"], unique=False)
    op.create_index(op.f("ix_call_edge_parent_id"), "call_edge", ["parent_id"], unique=False)
    op.create_table(
        "call_subtree_task",
        sa.Column("call_hash", sa.String(length=40), nullable=False),
        sa.Column("task_hash", sa.String(length=40), nullable=False),
        sa.ForeignKeyConstraint(
            ["call_hash"],
            ["call_node.call_hash"],
        ),
        sa.ForeignKeyConstraint(
            ["task_hash"],
            ["task.hash"],
        ),
        sa.PrimaryKeyConstraint("call_hash", "task_hash"),
    )
    op.create_index(
        op.f("ix_call_subtree_task_call_hash"), "call_subtree_task", ["call_hash"], unique=False
    )
    op.create_index(
        op.f("ix_call_subtree_task_task_hash"), "call_subtree_task", ["task_hash"], unique=False
    )
    op.create_table(
        "handle_edge",
        sa.Column("parent_id", sa.String(length=40), nullable=False),
        sa.Column("child_id", sa.String(length=40), nullable=False),
        sa.ForeignKeyConstraint(
            ["child_id"],
            ["handle.hash"],
        ),
        sa.ForeignKeyConstraint(
            ["parent_id"],
            ["handle.hash"],
        ),
        sa.PrimaryKeyConstraint("parent_id", "child_id"),
    )
    op.create_index(op.f("ix_handle_edge_child_id"), "handle_edge", ["child_id"], unique=False)
    op.create_index(op.f("ix_handle_edge_parent_id"), "handle_edge", ["parent_id"], unique=False)
    op.create_table(
        "job",
        sa.Column("id", sa.String(), nullable=False),
        sa.Column("start_time", sa.DateTime(), nullable=False),
        sa.Column("end_time", sa.DateTime(), nullable=True),
        sa.Column("task_hash", sa.String(length=40), nullable=False),
        sa.Column("cached", sa.Boolean(), nullable=False),
        sa.Column("call_hash", sa.String(length=40), nullable=True),
        sa.Column("parent_id", sa.String(), nullable=True),
        sa.ForeignKeyConstraint(
            ["call_hash"],
            ["call_node.call_hash"],
        ),
        sa.ForeignKeyConstraint(
            ["parent_id"],
            ["job.id"],
        ),
        sa.ForeignKeyConstraint(
            ["task_hash"],
            ["task.hash"],
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_index(op.f("ix_job_call_hash"), "job", ["call_hash"], unique=False)
    op.create_index(op.f("ix_job_parent_id"), "job", ["parent_id"], unique=False)
    op.create_index(op.f("ix_job_task_hash"), "job", ["task_hash"], unique=False)
    op.create_table(
        "argument_result",
        sa.Column("arg_hash", sa.String(length=40), nullable=False),
        sa.Column("result_call_hash", sa.String(length=40), nullable=False),
        sa.ForeignKeyConstraint(
            ["arg_hash"],
            ["argument.arg_hash"],
        ),
        sa.ForeignKeyConstraint(
            ["result_call_hash"],
            ["call_node.call_hash"],
        ),
        sa.PrimaryKeyConstraint("arg_hash", "result_call_hash"),
    )
    op.create_index(
        op.f("ix_argument_result_arg_hash"), "argument_result", ["arg_hash"], unique=False
    )
    op.create_index(
        op.f("ix_argument_result_result_call_hash"),
        "argument_result",
        ["result_call_hash"],
        unique=False,
    )
    op.create_table(
        "execution",
        sa.Column("id", sa.String(), nullable=False),
        sa.Column("args", sa.String(), nullable=False),
        sa.Column("job_id", sa.String(), nullable=False),
        sa.ForeignKeyConstraint(
            ["job_id"],
            ["job.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_index(op.f("ix_execution_job_id"), "execution", ["job_id"], unique=False)
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f("ix_execution_job_id"), table_name="execution")
    op.drop_table("execution")
    op.drop_index(op.f("ix_argument_result_result_call_hash"), table_name="argument_result")
    op.drop_index(op.f("ix_argument_result_arg_hash"), table_name="argument_result")
    op.drop_table("argument_result")
    op.drop_index(op.f("ix_job_task_hash"), table_name="job")
    op.drop_index(op.f("ix_job_parent_id"), table_name="job")
    op.drop_index(op.f("ix_job_call_hash"), table_name="job")
    op.drop_table("job")
    op.drop_index(op.f("ix_handle_edge_parent_id"), table_name="handle_edge")
    op.drop_index(op.f("ix_handle_edge_child_id"), table_name="handle_edge")
    op.drop_table("handle_edge")
    op.drop_index(op.f("ix_call_subtree_task_task_hash"), table_name="call_subtree_task")
    op.drop_index(op.f("ix_call_subtree_task_call_hash"), table_name="call_subtree_task")
    op.drop_table("call_subtree_task")
    op.drop_index(op.f("ix_call_edge_parent_id"), table_name="call_edge")
    op.drop_index(op.f("ix_call_edge_child_id"), table_name="call_edge")
    op.drop_table("call_edge")
    op.drop_index(op.f("ix_argument_value_hash"), table_name="argument")
    op.drop_index(op.f("ix_argument_call_hash"), table_name="argument")
    op.drop_table("argument")
    op.drop_index(op.f("ix_subvalue_value_hash"), table_name="subvalue")
    op.drop_index(op.f("ix_subvalue_parent_value_hash"), table_name="subvalue")
    op.drop_table("subvalue")
    op.drop_index(op.f("ix_handle_value_hash"), table_name="handle")
    op.drop_index(op.f("ix_handle_fullname"), table_name="handle")
    op.drop_table("handle")
    op.drop_table("file")
    op.drop_index(op.f("ix_call_node_value_hash"), table_name="call_node")
    op.drop_index(op.f("ix_call_node_task_hash"), table_name="call_node")
    op.drop_table("call_node")
    op.drop_table("value")
    op.drop_table("task")
    op.drop_table("redun_version")
    # ### end Alembic commands ###
