"""
Legacy setup.py for PyOghma ML

This file is maintained for backward compatibility with older Python packaging tools.
For modern installations, please use pyproject.toml with pip >= 21.0:

    pip install .

or for development:

    pip install -e .

Author: Cai Williams
Email: cai.williams@physik.tu-chemnitz.de
"""

import os
from setuptools import setup, find_packages

# Read the README file for long description
def read_readme():
    """Read README.md file for long description."""
    readme_path = os.path.join(os.path.dirname(__file__), 'README.md')
    if os.path.exists(readme_path):
        with open(readme_path, 'r', encoding='utf-8') as f:
            return f.read()
    return "A Python Pipeline for Machine Learning with Oghma"

# Core dependencies (matching pyproject.toml)
INSTALL_REQUIRES = [
    # Core scientific computing
    "numpy>=1.24.0",
    "scipy>=1.11.0",
    "pandas>=2.1.0",
    
    # Data handling and I/O
    "h5py>=3.9.0",
    "ujson>=5.8.0",
    
    # Visualization
    "matplotlib>=3.7.0",
    
    # Machine Learning and Deep Learning
    "tensorflow>=2.15.0",
    "keras>=3.0.0",
    "keras-tuner>=1.4.0",
    
    # Template and document generation
    "Jinja2>=3.1.0",
    
    # Utilities
    "natsort>=8.4.0",
    "fonttools>=4.40.0",
    
    # Build tools
    "setuptools>=68.0.0"
]

# Optional dependencies
EXTRAS_REQUIRE = {
    'dev': [
        "pytest>=7.0.0",
        "pytest-cov>=4.0.0",
        "black>=23.0.0",
        "flake8>=6.0.0",
        "mypy>=1.0.0",
    ],
    'docs': [
        "sphinx>=7.0.0",
        "sphinx-rtd-theme>=1.3.0",
        "myst-parser>=2.0.0",
    ],
    'gpu': [
        "tensorflow[and-cuda]>=2.15.0",
    ],
}

setup(
    name='PyOghma_ML',
    version='0.2.0',
    
    # Package discovery
    packages=find_packages(where='src'),
    package_dir={'': 'src'},
    
    # Metadata
    author='Cai Williams',
    author_email='cai.williams@physik.tu-chemnitz.de',
    description='A Python Pipeline for Machine Learning with Oghma',
    long_description=read_readme(),
    long_description_content_type='text/markdown',
    
    # URLs
    url='https://github.com/CaiWilliams/PyOghma_ML',
    project_urls={
        'Homepage': 'https://github.com/CaiWilliams/PyOghma_ML',
        'Issues': 'https://github.com/CaiWilliams/PyOghma_ML/issues',
    },
    
    # License and classifiers
    license='MIT',
    classifiers=[
        'Development Status :: 4 - Beta',
        'Intended Audience :: Science/Research',
        'License :: OSI Approved :: MIT License',
        'Operating System :: OS Independent',
        'Programming Language :: Python :: 3',
        'Programming Language :: Python :: 3.9',
        'Programming Language :: Python :: 3.10',
        'Programming Language :: Python :: 3.11',
        'Programming Language :: Python :: 3.12',
        'Topic :: Scientific/Engineering :: Artificial Intelligence',
        'Topic :: Scientific/Engineering :: Physics',
    ],
    
    # Dependencies
    python_requires='>=3.9',
    install_requires=INSTALL_REQUIRES,
    extras_require=EXTRAS_REQUIRE,
    
    # Keywords
    keywords=[
        'machine learning', 
        'photovoltaics', 
        'oghma', 
        'neural networks', 
        'solar cells'
    ],
    
    # Include additional files
    include_package_data=True,
    zip_safe=False,
)