
def generate_header(
	pose,
	# metadata,
	method,
	ref_url,
	submitter_name,
	submitter_email,
	submitter_institution,
	generation_date: str | None = None,
	extras=None,
	metadata: bool = True,
):
    """

    :param pose: 
    :param # metadata: 
    :param method: 
    :param ref_url: 
    :param submitter_name: 
    :param submitter_email: 
    :param submitter_institution: 
    :param generation_date: str | None:  (Default value = None)
    :param extras:  (Default value = None)
    :param metadata: bool:  (Default value = True)

    """

	extras = extras or {}

	from rdkit.Chem.AllChem import EmbedMolecule
	from molparse.rdkit import mol_from_smiles
	from datetime import date

	header = mol_from_smiles(pose.compound.smiles)

	header.SetProp('_Name', 'ver_1.2')
	EmbedMolecule(header)

	generation_date = str(generation_date or date.today())

	header.SetProp('ref_url', ref_url)
	header.SetProp('submitter_name', submitter_name)
	header.SetProp('submitter_email', submitter_email)
	header.SetProp('submitter_institution', submitter_institution)
	header.SetProp('generation_date', generation_date)
	header.SetProp('method', method)

	if metadata:
		for k,v in pose.metadata.items():
			header.SetProp(k, str(k))

	for k,v in extras.items():
		header.SetProp(k, str(v))

	return header
