"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CompliantDynamoDb = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const backup = require("@aws-cdk/aws-backup");
const dynamodb = require("@aws-cdk/aws-dynamodb");
const aws_events_1 = require("@aws-cdk/aws-events");
const iam = require("@aws-cdk/aws-iam");
const cdk = require("@aws-cdk/core");
/**
 * Creates a DynamoDB table that is secured by an AWS backup plan und with point in time recovery enabled by default.
 *
 * @stability stable
 */
class CompliantDynamoDb extends cdk.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _b, _c;
        super(scope, id);
        this.dynamodbTable = new dynamodb.Table(this, 'DynamoDBTable', {
            tableName: props.tableName,
            billingMode: dynamodb.BillingMode.PAY_PER_REQUEST,
            partitionKey: (_b = props.partitionKey) !== null && _b !== void 0 ? _b : {
                name: 'id',
                type: dynamodb.AttributeType.STRING,
            },
            sortKey: props.sortKey,
            pointInTimeRecovery: true,
            encryption: dynamodb.TableEncryption.CUSTOMER_MANAGED,
            encryptionKey: props.encryptionKey,
            contributorInsightsEnabled: props.contributorInsightsEnabled,
            kinesisStream: props.kinesisStream,
            replicationRegions: props.replicationRegions,
            replicationTimeout: props.replicationTimeout,
            timeToLiveAttribute: props.timeToLiveAttribute,
        });
        this.backupVault = new backup.BackupVault(this, 'BackupVault', {
            backupVaultName: `${props.tableName}-backup-vault`,
            accessPolicy: new iam.PolicyDocument({
                statements: [
                    new iam.PolicyStatement({
                        sid: 'backup-recovery-point-manual-deletion-disabled',
                        effect: iam.Effect.DENY,
                        principals: [new iam.AnyPrincipal()],
                        actions: [
                            'backup:DeleteRecoveryPoint',
                            'backup:PutBackupVaultAccessPolicy',
                            'backup:UpdateRecoveryPointLifecycle',
                        ],
                        resources: ['*'],
                    }),
                ],
            }),
        });
        this.backupPlan = new backup.BackupPlan(this, 'DynamoDbBackupPlan', {
            backupPlanName: `${this.dynamodbTable.tableName}-backup-plan`,
            backupVault: this.backupVault,
            backupPlanRules: [
                new backup.BackupPlanRule({
                    ruleName: 'daily-dynamodb-backup',
                    scheduleExpression: (_c = props.backupPlanStartTime) !== null && _c !== void 0 ? _c : aws_events_1.Schedule.cron({
                        hour: '21',
                        minute: '0',
                    }),
                    deleteAfter: cdk.Duration.days(35),
                }),
            ],
        });
        this.backupPlan.addSelection('DynamoDB', {
            resources: [backup.BackupResource.fromDynamoDbTable(this.dynamodbTable)],
        });
    }
}
exports.CompliantDynamoDb = CompliantDynamoDb;
_a = JSII_RTTI_SYMBOL_1;
CompliantDynamoDb[_a] = { fqn: "compliantdynamodb.CompliantDynamoDb", version: "0.0.21" };
//# sourceMappingURL=data:application/json;base64,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