# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['what_to_eat',
 'what_to_eat.gateways',
 'what_to_eat.models',
 'what_to_eat.services']

package_data = \
{'': ['*']}

install_requires = \
['httpx>=0.23.0,<0.24.0',
 'inquirer>=2.10.1,<3.0.0',
 'pydantic>=1.10.2,<2.0.0',
 'typer[all]>=0.7.0,<0.8.0']

entry_points = \
{'console_scripts': ['what-to-eat = what_to_eat.main:app']}

setup_kwargs = {
    'name': 'what-to-eat',
    'version': '0.1.0',
    'description': 'What to eat? CLI tool to interaction with Wolt API',
    'long_description': '<h2>🍔 What to eat? 🍕</h2>\n<p align="center">\n    <em>CLI tool to query Wolt API in your location!</em>\n</p>\n\n---\nWhy to use *what-to-eat*? How many times have you not known what to order for dinner or lunch? *What-to-eat* will help you querying and filtering restaurants available in your location via [Wolt](https://wolt.com/pl/discovery) app! 🍔\n\nExample usage:\n\n<p align="center">\n    <img src="./images/ls-query-example.png" alt="demo" width="900"/>\n</p>\n\n<h3>🛠️ Installation</h3>\n\n```console\nwork in progress\n```\n\n<h3>💬 Available commands</h3>\n\nThere are currently 3 commands available, one of which is used to configure the tool: `configure`, `ls`, `random`:\n\n```console\n$ what-to-eat --help\n\n Usage: what-to-eat [OPTIONS] COMMAND [ARGS]...\n\n╭─ Options ────────────────────────────────────────────────────────────────────╮\n│ --install-completion          Install completion for the current shell.      │\n│ --show-completion             Show completion for the current shell, to copy │\n│                               it or customize the installation.              │\n│ --help                        Show this message and exit.                    │\n╰──────────────────────────────────────────────────────────────────────────────╯\n╭─ Commands ───────────────────────────────────────────────────────────────────╮\n│ configure       Create configuration file to your orders                     │\n│ ls              Finds best restaurants via Wolt API                          │\n│ random          Finds random restaurant via Wolt API                         │\n╰──────────────────────────────────────────────────────────────────────────────╯\n\n```\n\nYou can find examples of using these commands in the section below.\n\n\n<h3>✨ Examples</h3>\nConfigure your tool:\n\n```console\n$ what-to-eat configure\n```\n\n\nList all available restaurants in your localization:\n\n```console\n$ what-to-eat ls\n```\n\n\nSort restaurants by `rating` and limit results to 5 records:\n```console\n$ what-to-eat ls --sort rating --ordering desc --limit 5\n┏━━━━━┳━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┳━━━━━━━━━━━━━━━━━━━━━━━━━━┳━━━━━━━━━━━━━━━┳━━━━━━━━━━━━━━━┳━━━━━━━━┳━━━━━━━┳━━━━━━━━━━━━━━━━━━━━━┓\n┃ No. ┃                               Restaurant ┃                  Address ┃ Estimate time ┃ Delivery cost ┃ Rating ┃ Price ┃                Tags ┃\n┡━━━━━╇━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━╇━━━━━━━━━━━━━━━━━━━━━━━━━━╇━━━━━━━━━━━━━━━╇━━━━━━━━━━━━━━━╇━━━━━━━━╇━━━━━━━╇━━━━━━━━━━━━━━━━━━━━━┩\n│ 1   │               Mikropiekarnia Pochlebstwo │       Romanowicza 5/LU7b │   25 - 35 min │ (No delivery) │   10.0 │  💰💰 │     Bakery, Grocery │\n│ 2   │                            KruKam Kraków │        ul. Krakowska 35A │   30 - 40 min │ (No delivery) │    9.8 │  💰💰 │    Grocery, Healthy │\n│ 3   │                    Piekarnia Mojego Taty │           ul. Meiselsa 6 │   20 - 30 min │ (No delivery) │    9.8 │    💰 │     Bakery, Grocery │\n│ 4   │  MARLIN - Fish & Chips - Smażalnie Rybne │ Krowoderskich Zuchów 21A │   45 - 55 min │ (No delivery) │    9.6 │  💰💰 │ Fish, Mediterranean │\n│ 5   │ Lody Ice Cream NOW - Stare Miasto II (K) │  This is a virtual venue │   20 - 30 min │ (No delivery) │    9.6 │  💰💰 │           Ice cream │\n└─────┴──────────────────────────────────────────┴──────────────────────────┴───────────────┴───────────────┴────────┴───────┴─────────────────────┘\n                                                        🍿 Restaurants in Kraków via wolt 🍿\n```\n\n\nBy default your first profile is `default` one. But while listing restaurants you can change it using `profile` option:\n\n```console\n$ what-to-eat ls --profile work\n```\n\nYou can also display restaurant details:\n\n```console\n$ what-to-eat ls \'KruKam Kraków\'\n┏━━━━━━━━━━━━━━━━━━┳━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┓\n┃ 🍕 KruKam Kraków ┃                       Kraków, ul. Krakowska 35A 🍕 ┃\n┡━━━━━━━━━━━━━━━━━━╇━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┩\n│           Rating │                           Amazing (9 / 10 reviews) │\n│            Price │                                               💰💰 │\n│          Website │ https://wolt.com/pl/pol/krakow/venue/krukam-krakow │\n│            Phone │                                      +48 533442291 │\n│  Payment Methods │                                               Card │\n│             Tags │                 Grocery, Healthy, Sweet, Specialty │\n└──────────────────┴────────────────────────────────────────────────────┘\n```\n\nHowever, perhaps the coolest options is to randomly select restaurants.\n```console\n$ what-to-eat random\n```\n\n**Note:** The selection algorithm is based on the ranking and delivery time for a given restaurant.\n\nYou can also enter a tag based on which a restaurant will be randomly selected:\n\n```console\n$ what-to-eat random --tag pizza\n```\n\n\n<h3>📚 License</h3>\n\nThis project is licensed under the terms of the MIT license.\n',
    'author': 'Kamil Woźniak',
    'author_email': 'jestem.kamil.wozniak@gmail.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.10,<4.0',
}


setup(**setup_kwargs)
