import os
from setuptools import find_packages, setup

with open(os.path.join(os.path.dirname(__file__), 'README.rst')) as readme:
    README = readme.read()

# allow setup.py to be run from any path
os.chdir(os.path.normpath(os.path.join(os.path.abspath(__file__), os.pardir)))

setup(
    name='django-easy-services',
    version='0.3',
    packages=find_packages(),
    include_package_data=True,
    install_requires=['Django>=1.8', 'requests>=2.20.0', 'asyncio>=3.4.3', 'django-multiselectfield>=0.1.12'],
    license='MIT License',
    description='A simple Django app to handle services request.',
    long_description=README,
    url='https://github.com/lmendes86/django-services/',
    author='Lucas Mendes',
    author_email='lucasam86@gmail.com',
    maintainer="Lucas Mendes",
    maintainer_email="lucasam86@gmail.com",
    classifiers=[
        'Environment :: Web Environment',
        'Framework :: Django',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: MIT License',
        'Operating System :: OS Independent',
        'Programming Language :: Python',
        'Programming Language :: Python :: 3',
        'Topic :: Internet :: WWW/HTTP',
        'Topic :: Internet :: WWW/HTTP :: Dynamic Content',
    ],
)
