import sys

P2P_PROTOCOL_VERSION = 4
ETH_PROTOCOL_VERSION = 64
SUPPORTED_ETH_PROTOCOL_VERSION = [ETH_PROTOCOL_VERSION, 63]
CAPABILITIES = ((b"eth", ETH_PROTOCOL_VERSION),)
BX_ETH_CLIENT_NAME = b"BloxRoute Gateway"

SIGNATURE_LEN = 65
MDC_LEN = 32
MAC_LEN = 32

MSG_TYPE_LEN = 1
MSG_HEADER_OFF = 0

PRIVATE_KEY_LEN = 32
PUBLIC_KEY_LEN = 64
PUBLIC_KEY_X_Y_LEN = 32

ECIES_CIPHER_NAME = "aes-128-ctr"
RLPX_CIPHER_NAME = "aes-256-ctr"
ECIES_CURVE = "secp256k1"
ECIES_ENCRYPT_OVERHEAD_LENGTH = 113
ECIES_HEADER = 0x04
ECIES_HEADER_BYTE = b"\x04"
ECIES_HEADER_LEN = 1

KEY_MATERIAL_LEN = 32
SHARED_KEY_LEN = 32
ENC_KEY_LEN = 16
IV_LEN = 16

CIPHER_DECRYPT_DO = 0
CIPHER_ENCRYPT_DO = 1

PING_MSG_TTL_SEC = 60

FRAME_HDR_TOTAL_LEN = 32
FRAME_HDR_DATA_LEN = 16
FRAME_MAC_LEN = 16
MSG_PADDING = 16
FRAME_MAX_BODY_SIZE = 256 ** 3
FRAME_MSG_TYPE_LEN = 1

DEFAULT_FRAME_SIZE = sys.maxsize
DEFAULT_FRAME_PROTOCOL_ID = 0
MAX_FRAME_SEQUENCE_ID = 2 ** 16

ENC_AUTH_MSG_LEN = 307
EIP8_AUTH_PREFIX_LEN = 2
EIP8_ACK_PAD_MIN = 100
EIP8_ACK_PAD_MAX = 250
AUTH_MSG_LEN = 194
AUTH_ACK_MSG_LEN = 97
ENC_AUTH_ACK_MSG_LEN = 210
AUTH_NONCE_LEN = 32
AUTH_MSG_VERSION = 4
MAX_NONCE = 2 ** 256 - 1

SHA3_LEN_BYTES = 32
SHA3_LEN_BITS = 256

BLOCK_HASH_LEN = 32
ADDRESS_LEN = 20
MERKLE_ROOT_LEN = 32
BLOOM_LEN = 256
FIXED_LENGTH_FIELD_OFFSET = 2 * BLOCK_HASH_LEN + ADDRESS_LEN + 3 * MERKLE_ROOT_LEN + BLOOM_LEN + 9

HANDSHAKE_TIMEOUT_SEC = 30
PING_PONG_INTERVAL_SEC = 30
PING_PONG_TIMEOUT_SEC = 60
DISCONNECT_DELAY_SEC = 2
DISCOVERY_PONG_TIMEOUT_SEC = 5

DISCONNECT_REASON_TIMEOUT = 0x0b

CHECKPOINT_BLOCK_HEADERS_REQUEST_WAIT_TIME_S = 5

MSG_CLS_SERIALIZER_ATTR = "serializer"

BLOCK_CLEANUP_NODE_BLOCK_LIST_POLL_INTERVAL_S = 0
TRACKED_BLOCK_CLEANUP_INTERVAL_S = 15

LAST_KNOWN_TOTAL_DIFFICULTIES_MAX_COUNT = 10
NEW_BLOCK_PARTS_MAX_WAIT_S = 5
REQUESTED_NEW_BLOCK_HEADERS_MAX_COUNT = 10
REQUESTED_NEW_BLOCK_BODIES_MAX_COUNT = 10

CHECK_BLOCK_RECEIPT_DELAY_S = 0.1
CHECK_BLOCK_RECEIPT_INTERVAL_S = 0.1
CHECK_BLOCK_RECEIPT_MAX_COUNT = 5

GATEWAY_PRIVATE_KEY_FILE_NAME = ".gatewaykey"
BLOCK_CONFIRMATION_REQUEST_INTERVALS = 5
BLOCK_CONFIRMATION_REQUEST_CACHE_INTERVAL_S = 30 * 60

EIP155_CHAIN_ID_OFFSET = 35

ETH_DEFAULT_BLOCK_SIZE = 100000
ETH_MINIMAL_SUB_TASK_TX_COUNT = 100

# skip transaction messages for 30s if they're greater than 30k in size
# Geth packs sync messages to 100k, should check other implementations
# these sync messages are usually useless to the BDN
ETH_SKIP_TRANSACTIONS_LEAD_TIME_S = 30
ETH_SKIP_TRANSACTIONS_SIZE = 30000

MAX_FUTURE_BLOCK_NUMBER: int = 100
MAX_DIFFICULTY_CHANGE_PERCENT: int = 10

MAX_TRANSACTION_TYPE = 0xBF

