from robotpy_toolkit_7407.unum import Unum, units

# --- UNUMS ---
m = units.m
ft = Unum.unit("ft", 0.3048 * m, "foot")
inch = Unum.unit("in", ft / 12, "inch")
mile = units.mile

s = units.s
ms = units.ms
minute = units.min
hour = units.h

rad = units.rad
deg = units.deg
rev = Unum.unit("rev", 360 * deg, "revolution")


# --- TYPING ---
meters = float
radians = float
seconds = float
meters_per_second = float
meters_per_second_squared = float
radians_per_second = float
radians_per_second_squared = float
radians_per_meter = float
meters_per_radian = float
