"""Version of ansys-mechanical-core module.

On the ``main`` branch, use 'dev0' to denote a development version.
For example:

# major, minor, patch
version_info = 0, 58, 'dev0'

"""

try:
    import importlib.metadata as importlib_metadata
except ModuleNotFoundError:  # pragma: no cover
    import importlib_metadata

# Read from the pyproject.toml
# major, minor, patch
__version__ = importlib_metadata.version("ansys-mechanical-core")

# In descending order
SUPPORTED_MECHANICAL_VERSIONS = {
    232: "2023R2",
    231: "2023R1",
}
