"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const assert_1 = require("@aws-cdk/assert");
const ec2 = require("@aws-cdk/aws-ec2");
const elbv2 = require("@aws-cdk/aws-elasticloadbalancingv2");
const core_1 = require("@aws-cdk/core");
const targets = require("../lib");
test('Can create target groups with instance id target', () => {
    // GIVEN
    const stack = new core_1.Stack();
    const vpc = new ec2.Vpc(stack, 'Stack');
    const lb = new elbv2.ApplicationLoadBalancer(stack, 'LB', { vpc });
    const listener = lb.addListener('Listener', { port: 80 });
    // WHEN
    listener.addTargets('Targets', {
        targets: [new targets.InstanceIdTarget('i-1234')],
        port: 80,
    });
    // THEN
    assert_1.expect(stack).to(assert_1.haveResource('AWS::ElasticLoadBalancingV2::TargetGroup', {
        Port: 80,
        Protocol: "HTTP",
        Targets: [
            { Id: "i-1234" }
        ],
        TargetType: "instance",
    }));
});
test('Can create target groups with instance target', () => {
    // GIVEN
    const stack = new core_1.Stack();
    const vpc = new ec2.Vpc(stack, 'Stack');
    const lb = new elbv2.ApplicationLoadBalancer(stack, 'LB', { vpc });
    const listener = lb.addListener('Listener', { port: 80 });
    const instance = new ec2.Instance(stack, 'Instance', {
        vpc,
        machineImage: new ec2.AmazonLinuxImage(),
        instanceType: ec2.InstanceType.of(ec2.InstanceClass.T3, ec2.InstanceSize.LARGE),
    });
    // WHEN
    listener.addTargets('Targets', {
        targets: [new targets.InstanceTarget(instance)],
        port: 80,
    });
    // THEN
    assert_1.expect(stack).to(assert_1.haveResource('AWS::ElasticLoadBalancingV2::TargetGroup', {
        Port: 80,
        Protocol: "HTTP",
        Targets: [
            { Id: { Ref: 'InstanceC1063A87' } }
        ],
        TargetType: "instance",
    }));
});
//# sourceMappingURL=data:application/json;base64,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