import { Construct } from 'constructs';
/**
 * @experimental
 */
export interface STSOptions {
    /**
     * (experimental) The Kubernetes namespace where this app to be deployed.
     *
     * @default 'default'
     * @experimental
     */
    readonly namespace?: string;
    /**
     * (experimental) The Docker image to use for this app.
     *
     * @experimental
     */
    readonly image: string;
    /**
     * (experimental) Number of replicas.
     *
     * @default 3
     * @experimental
     */
    readonly defaultReplicas?: number;
    /**
     * (experimental) The Volume size of our DB in string, e.g 10Gi, 20Gi.
     *
     * @experimental
     */
    readonly volumeSize?: string;
    /**
     * (experimental) Option to create storage class, if enabled, a storage class will be created for the statefulset.
     *
     * @default true
     * @experimental
     */
    readonly createStorageClass?: boolean;
    /**
     * (experimental) The storage class to use for our PVC.
     *
     * @default 'gp2-expandable'
     * @experimental
     */
    readonly storageClassName?: string;
    /**
     * (experimental) Each StorageClass has a provisioner that determines what volume plugin is used for provisioning PVs.
     *
     * This field must be specified.
     * See [this](https://kubernetes.io/docs/concepts/storage/storage-classes/#provisioner) for Ref
     *
     * @default 'kubernetes.io/aws-ebs'
     * @experimental
     */
    readonly volumeProvisioner?: string;
    /**
     * (experimental) Storage class params.
     *
     * @default - { type = gp2, fsType: ext4 }
     * @experimental
     */
    readonly storageClassParams?: {
        [name: string]: string;
    };
    /**
     * (experimental) nodeSelector params.
     *
     * @default - undefined
     * @experimental
     */
    readonly nodeSelectorParams?: {
        [name: string]: string;
    };
    /**
     * (experimental) Resources requests for the DB.
     *
     * @default - Requests = { CPU = 200m, Mem = 256Mi }, Limits = { CPU = 400m, Mem = 512Mi }
     * @experimental
     */
    readonly resources?: ResourceRequirements;
}
/**
 * @experimental
 */
export interface ResourceRequirements {
    /**
     * (experimental) Maximum resources for the web app.
     *
     * @default - CPU = 400m, Mem = 512Mi
     * @experimental
     */
    readonly limits?: ResourceQuantity;
    /**
     * (experimental) Required resources for the web app.
     *
     * @default - CPU = 200m, Mem = 256Mi
     * @experimental
     */
    readonly requests?: ResourceQuantity;
}
/**
 * @experimental
 */
export interface ResourceQuantity {
    /**
     * @default - no limit
     * @experimental
     */
    readonly cpu?: string;
    /**
     * @default - no limit
     * @experimental
     */
    readonly memory?: string;
}
/**
 * (experimental) MongoDB Stateful Set class.
 *
 * @experimental
 */
export declare class MyMongo extends Construct {
    /**
     * @experimental
     */
    readonly name: string;
    /**
     * @experimental
     */
    readonly namespace: string;
    /**
     * @experimental
     */
    constructor(scope: Construct, name: string, opts: STSOptions);
}
