import * as cdk from 'aws-cdk-lib';
import * as constructs from 'constructs';
/**
 * Allows privileges to be granted on a role to a user. https://docs.snowflake.com/en/sql-reference/sql/grant-privilege.html
 *
 * @schema CfnGrantProps
 */
export interface CfnGrantProps {
    /**
     * @schema CfnGrantProps#RoleName
     */
    readonly roleName: string;
    /**
     * @schema CfnGrantProps#User
     */
    readonly user: string;
}
/**
 * Converts an object of type 'CfnGrantProps' to JSON representation.
 */
export declare function toJson_CfnGrantProps(obj: CfnGrantProps | undefined): Record<string, any> | undefined;
/**
 * A CloudFormation `Snowflake::Role::Grant`
 *
 * @cloudformationResource Snowflake::Role::Grant
 * @stability external
 * @link https://github.com/aws-ia/cloudformation-snowflake-resource-providers.git
 */
export declare class CfnGrant extends cdk.CfnResource {
    /**
    * The CloudFormation resource type name for this resource class.
    */
    static readonly CFN_RESOURCE_TYPE_NAME = "Snowflake::Role::Grant";
    /**
     * Resource props.
     */
    readonly props: CfnGrantProps;
    /**
     * Create a new `Snowflake::Role::Grant`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: constructs.Construct, id: string, props: CfnGrantProps);
}
