from setuptools import setup, find_packages
import codecs
import os

here = os.path.abspath(os.path.dirname(__file__))

with codecs.open(os.path.join(here, "README.md"), encoding="utf-8") as fh:
    long_description = "\n" + fh.read()

VERSION = '0.0.1'
DESCRIPTION = 'Python MongoDB helper'
LONG_DESCRIPTION = 'Python MongoDB wrapper that has functionalities to find by id and return lists and dictionaries.'

# Setting up
setup(
    name="mongohelper",
    version=VERSION,
    author="Alan Ngo",
    author_email="<alanngo673@gmail.com>",
    description=DESCRIPTION,
    long_description_content_type="text/markdown",
    long_description=LONG_DESCRIPTION,
    packages=find_packages(),
    install_requires=['pymongo', 'dnspython'],
    keywords=['pymongo', 'dnspython'],
    classifiers=[
        "Development Status :: 1 - Planning",
        "Intended Audience :: Developers",
        "Programming Language :: Python :: 3",
        "Operating System :: Unix",
        "Operating System :: MacOS :: MacOS X",
        "Operating System :: Microsoft :: Windows"
    ]
)