"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SageMakerImage = exports.SageMakerImageType = exports.SageMakerDistributionImageSingletonID = exports.SageMakerImageSingletonID = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("aws-cdk-lib/core");
exports.SageMakerImageSingletonID = "sagemaker:image:mapping";
exports.SageMakerDistributionImageSingletonID = "sagemaker:image:mapping:distribution";
var SageMakerImageType;
(function (SageMakerImageType) {
    SageMakerImageType["DISTRIBUTION"] = "Distribution";
    SageMakerImageType["IMAGE"] = "Image";
})(SageMakerImageType || (exports.SageMakerImageType = SageMakerImageType = {}));
// AWS stores each image in a different account based on two factors:
// 1. The region
// 2. Whether it is a "Distribution Image" or a "Standard Image"
// https://docs.aws.amazon.com/sagemaker/latest/dg/notebooks-available-images.html
const imageArnAccounts = {
    "us-east-1": "081325390199",
    "us-east-2": "429704687514",
    "us-west-1": "742091327244",
    "us-west-2": "236514542706",
    "af-south-1": "559312083959",
    "ap-east-1": "493642496378",
    "ap-south-1": "394103062818",
    "ap-northeast-2": "806072073708",
    "ap-southeast-1": "492261229750",
    "ap-southeast-2": "452832661640",
    "ap-northeast-1": "102112518831",
    "ca-central-1": "310906938811",
    "eu-central-1": "936697816551",
    "eu-west-1": "470317259841",
    "eu-west-2": "712779665605",
    "eu-west-3": "615547856133",
    "eu-north-1": "243637512696",
    "eu-south-1": "592751261982",
    "sa-east-1": "782484402741",
    "ap-northeast-3": "792733760839",
    "ap-southeast-3": "276181064229",
    "me-south-1": "117516905037",
    "me-central-1": "103105715889",
};
const distributionImageArnAccounts = {
    "us-east-1": "885854791233",
    "us-east-2": "137914896644",
    "us-west-1": "053634841547",
    "us-west-2": "542918446943",
    "af-south-1": "238384257742",
    "ap-east-1": "523751269255",
    "ap-south-1": "245090515133",
    "ap-northeast-2": "064688005998",
    "ap-southeast-1": "022667117163",
    "ap-southeast-2": "648430277019",
    "ap-northeast-1": "010972774902",
    "ca-central-1": "481561238223",
    "eu-central-1": "545423591354",
    "eu-west-1": "819792524951",
    "eu-west-2": "021081402939",
    "eu-west-3": "856416204555",
    "eu-north-1": "175620155138",
    "eu-south-1": "810671768855",
    "sa-east-1": "567556641782",
    "ap-northeast-3": "564864627153",
    "ap-southeast-3": "370607712162",
    "me-south-1": "523774347010",
    "me-central-1": "358593528301",
};
class SageMakerImage {
    constructor(resourceId, imageType) {
        this.resourceId = resourceId;
        this.imageType = imageType;
    }
    getArnForStack(stack) {
        const [singletonId, mappings] = this.imageType === SageMakerImageType.IMAGE
            ? [exports.SageMakerImageSingletonID, imageArnAccounts]
            : [exports.SageMakerDistributionImageSingletonID, distributionImageArnAccounts];
        // this maps the region to the AWS-owned account that owns the image
        const regionToAccount = stack.node.tryFindChild(singletonId) ??
            new core_1.CfnMapping(stack, singletonId, {
                mapping: Object.fromEntries(Object.entries(mappings).map(([region, account]) => [
                    region,
                    { account },
                ])),
            });
        const region = stack.region;
        return core_1.Arn.format({
            partition: "aws",
            service: "sagemaker",
            region,
            account: regionToAccount.findInMap(region, "account"),
            resource: "image",
            resourceName: this.resourceId,
        });
    }
}
exports.SageMakerImage = SageMakerImage;
_a = JSII_RTTI_SYMBOL_1;
SageMakerImage[_a] = { fqn: "@packyak/aws-cdk.SageMakerImage", version: "0.3.6" };
SageMakerImage.CPU_V1 = new SageMakerImage("sagemaker-distribution-cpu-v1", SageMakerImageType.DISTRIBUTION);
SageMakerImage.CPU_V0 = new SageMakerImage("sagemaker-distribution-cpu-v0", SageMakerImageType.DISTRIBUTION);
SageMakerImage.GPU_V0 = new SageMakerImage("sagemaker-distribution-gpu-v0", SageMakerImageType.DISTRIBUTION);
SageMakerImage.GPU_V1 = new SageMakerImage("sagemaker-distribution-gpu-v1", SageMakerImageType.DISTRIBUTION);
//# sourceMappingURL=data:application/json;base64,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