import { type Stack } from "aws-cdk-lib/core";
export declare const SageMakerImageSingletonID = "sagemaker:image:mapping";
export declare const SageMakerDistributionImageSingletonID = "sagemaker:image:mapping:distribution";
export declare enum SageMakerImageType {
    DISTRIBUTION = "Distribution",
    IMAGE = "Image"
}
export declare class SageMakerImage {
    private readonly resourceId;
    private readonly imageType;
    static readonly CPU_V1: SageMakerImage;
    static readonly CPU_V0: SageMakerImage;
    static readonly GPU_V0: SageMakerImage;
    static readonly GPU_V1: SageMakerImage;
    constructor(resourceId: string, imageType: SageMakerImageType);
    getArnForStack(stack: Stack): string;
}
