"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.NessieLambdaCatalog = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_lambda_1 = require("aws-cdk-lib/aws-lambda");
const path = require("path");
const base_nessie_catalog_js_1 = require("./base-nessie-catalog.js");
class NessieLambdaCatalog extends base_nessie_catalog_js_1.BaseNessieCatalog {
    constructor(scope, id, props) {
        super(scope, id, props);
        // TODO: none of this is right
        // see: https://project-nessie.zulipchat.com/#narrow/stream/371187-general/topic/AWS.20Lambda.20with.20SnapStart
        this.function = new aws_lambda_1.Function(this, "Function", {
            runtime: aws_lambda_1.Runtime.JAVA_17,
            snapStart: aws_lambda_1.SnapStartConf.ON_PUBLISHED_VERSIONS,
            code: aws_lambda_1.Code.fromAsset(path.join(__dirname, "lambda")),
            handler: "io.quarkus.amazon.lambda.runtime.QuarkusStreamHandler::handleRequest",
        });
        this.functionUrl = this.function.addFunctionUrl({
            authType: aws_lambda_1.FunctionUrlAuthType.AWS_IAM,
            // TODO: what's right here? Maybe streaming?
            invokeMode: aws_lambda_1.InvokeMode.BUFFERED,
        });
        this.endpoint = this.functionUrl.url;
    }
}
exports.NessieLambdaCatalog = NessieLambdaCatalog;
_a = JSII_RTTI_SYMBOL_1;
NessieLambdaCatalog[_a] = { fqn: "@packyak/aws-cdk.NessieLambdaCatalog", version: "0.3.6" };
//# sourceMappingURL=data:application/json;base64,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