"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.NessieECSCatalog = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_ecr_assets_1 = require("aws-cdk-lib/aws-ecr-assets");
const aws_ecs_1 = require("aws-cdk-lib/aws-ecs");
const aws_ecs_patterns_1 = require("aws-cdk-lib/aws-ecs-patterns");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const base_nessie_catalog_js_1 = require("./base-nessie-catalog.js");
const aws_logs_1 = require("aws-cdk-lib/aws-logs");
class NessieECSCatalog extends base_nessie_catalog_js_1.BaseNessieCatalog {
    constructor(scope, id, props) {
        super(scope, id, props);
        const platform = props?.platform ?? aws_ecr_assets_1.Platform.LINUX_AMD64;
        const taskRole = new aws_iam_1.Role(this, "TaskRole", {
            assumedBy: new aws_iam_1.ServicePrincipal("ecs-tasks.amazonaws.com"),
        });
        // TODO: logs
        this.grantPrincipal = taskRole;
        this.logGroup =
            props.logGroup ??
                new aws_logs_1.LogGroup(this, "LogGroup", {
                    logGroupName: `/nessie/${this.catalogName}`,
                });
        this.service = new aws_ecs_patterns_1.ApplicationLoadBalancedFargateService(this, "Service", {
            cluster: props?.cluster,
            vpc: props.vpc,
            serviceName: props.serviceName,
            runtimePlatform: {
                cpuArchitecture: platform === aws_ecr_assets_1.Platform.LINUX_AMD64
                    ? aws_ecs_1.CpuArchitecture.X86_64
                    : aws_ecs_1.CpuArchitecture.ARM64,
                operatingSystemFamily: aws_ecs_1.OperatingSystemFamily.LINUX,
            },
            cpu: props?.cpu ?? 256,
            memoryLimitMiB: props?.memoryLimitMiB ?? 512,
            publicLoadBalancer: true,
            certificate: props?.dns?.certificate,
            domainName: props?.dns?.domainName,
            domainZone: props?.dns?.hostedZone,
            taskImageOptions: {
                ...(props?.taskImageOptions ?? {}),
                environment: {
                    ...this.configAsEnvVars(),
                    ...props?.taskImageOptions?.environment,
                },
                logDriver: aws_ecs_1.AwsLogDriver.awsLogs({
                    streamPrefix: "nessie",
                    logGroup: this.logGroup,
                }),
                containerPort: props?.taskImageOptions?.containerPort ?? 19120,
                taskRole,
                image: props?.taskImageOptions?.image ??
                    aws_ecs_1.ContainerImage.fromRegistry("ghcr.io/projectnessie/nessie"),
            },
        });
        // this.service.loadBalancer.addListener("HTTPS", {
        //   port: 443,
        //   protocol: ApplicationProtocol.HTTPS,
        // });
        this.versionStore.grantReadWriteData(taskRole);
        this.service.targetGroup.configureHealthCheck({
            // uses smallrye-health:
            // see: https://redhat-developer-demos.github.io/quarkus-tutorial/quarkus-tutorial/health.html
            path: "/q/health",
        });
        if (props?.dns) {
            this.endpoint = `https://${props.dns.domainName}`;
        }
        else {
            this.endpoint = `http://${this.service.loadBalancer.loadBalancerDnsName}`;
        }
    }
}
exports.NessieECSCatalog = NessieECSCatalog;
_a = JSII_RTTI_SYMBOL_1;
NessieECSCatalog[_a] = { fqn: "@packyak/aws-cdk.NessieECSCatalog", version: "0.3.6" };
//# sourceMappingURL=data:application/json;base64,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