"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.NessieVersionStoreType = exports.nessieConfigToEnvironment = void 0;
function nessieConfigToEnvironment(config) {
    return Object.fromEntries(Object.entries(config).map(([k, v]) => [
        k.toUpperCase().replace(/[\._-]/g, "_"),
        v.toString(),
    ]));
}
exports.nessieConfigToEnvironment = nessieConfigToEnvironment;
/**
 * TODO: support others if necessary. For now DynamoDB is ideal for AWS.
 *
 * @see https://projectnessie.org/try/configuration/#support-for-the-database-specific-implementations
 */
var NessieVersionStoreType;
(function (NessieVersionStoreType) {
    NessieVersionStoreType["DYNAMODB"] = "DYNAMODB";
})(NessieVersionStoreType || (exports.NessieVersionStoreType = NessieVersionStoreType = {}));
//# sourceMappingURL=data:application/json;base64,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