"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.construct = exports.stack = void 0;
const core_1 = require("aws-cdk-lib/core");
const types_1 = require("util/types");
function stack(func) {
    return construct(func, core_1.Stack);
}
exports.stack = stack;
function construct(func, 
// @ts-ignore
base = Construct) {
    // @ts-ignore
    return class extends base {
        constructor(scope, id, props) {
            super(scope, id);
            // @ts-expect-error - we are being naughty and we know it
            const result = func.bind(this)(props);
            if ((0, types_1.isPromise)(result)) {
                // biome-ignore lint/correctness/noConstructorReturn: <explanation>
                return result.then((outputs) => {
                    Object.assign(this, outputs);
                    return this;
                });
            }
            else {
                Object.assign(this, result);
            }
        }
    };
}
exports.construct = construct;
//# sourceMappingURL=data:application/json;base64,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