"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SparkSqlExtension = void 0;
class SparkSqlExtension {
    constructor(groupId, artifactId, pkgVersion, className) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.pkgVersion = pkgVersion;
        this.className = className;
    }
    maven(sparkVersion, scalaVersion) {
        return `${this.groupId}:${this.artifactId}-${sparkVersion.majorMinorVersion}_${scalaVersion.majorMinorVersion}:${this.pkgVersion}`;
    }
}
exports.SparkSqlExtension = SparkSqlExtension;
SparkSqlExtension.Nessie = new SparkSqlExtension("org.projectnessie.nessie-integrations", "nessie-spark-extensions", "0.76.6", "org.projectnessie.spark.extensions.NessieSparkSessionExtensions");
SparkSqlExtension.Iceberg = new SparkSqlExtension("org.apache.iceberg", "iceberg-spark-runtime", "1.4.3", "org.apache.iceberg.spark.extensions.IcebergSparkSessionExtensions");
//# sourceMappingURL=data:application/json;base64,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