"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.mergeSparkExtraJars = exports.parseCLIArgs = exports.toCLIArgs = void 0;
/**
 * Format a set of CLI options into a string where {key}={value}.
 */
function toCLIArgs(options) {
    return Object.entries(options)
        .map(([key, value]) => `${key}=${value}`)
        .join(" ");
}
exports.toCLIArgs = toCLIArgs;
/**
 * Parse a CLI options string into a key-value pair record.
 */
function parseCLIArgs(optionsString) {
    const optionsArray = optionsString.split(" ");
    const optionsRecord = {};
    optionsArray.forEach((option) => {
        const [key, value] = option.split("=");
        if (key && value) {
            optionsRecord[key] = value;
        }
    });
    return optionsRecord;
}
exports.parseCLIArgs = parseCLIArgs;
function mergeSparkExtraJars(...args) {
    return toCLIArgs(args.reduce((acc, current) => {
        if (typeof current === "string") {
            current = parseCLIArgs(current);
        }
        else if (current === undefined) {
            current = {};
        }
        return { ...acc, ...current };
    }, {}));
}
exports.mergeSparkExtraJars = mergeSparkExtraJars;
//# sourceMappingURL=data:application/json;base64,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