"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.combineConfigurations = void 0;
const spark_config_1 = require("./spark-config");
// TODO: if keys like `"spark.jars.packages"` collide, join by , and dedupe
function combineConfigurations(...configs) {
    const mergedConfigurations = configs.reduce((finalConfig, next) => {
        const { classification, configurationProperties } = next;
        if (!finalConfig[classification]) {
            finalConfig[classification] = {
                classification,
                configurationProperties: {},
            };
        }
        const csvProperties = new Set([
            "spark.jars.packages",
            "spark.sql.extensions",
        ]);
        for (const [key, value] of Object.entries(configurationProperties)) {
            if (csvProperties.has(key)) {
                const existing = finalConfig[classification].configurationProperties[key]
                    ? finalConfig[classification].configurationProperties[key].split(",")
                    : [];
                const newValues = value.split(",");
                const merged = [...new Set([...existing, ...newValues])].join(",");
                finalConfig[classification].configurationProperties[key] = merged;
            }
            else if (key == "spark.driver.extraJavaOptions") {
                finalConfig[classification].configurationProperties[key] =
                    (0, spark_config_1.mergeSparkExtraJars)(finalConfig[classification].configurationProperties[key], value);
            }
            else {
                finalConfig[classification].configurationProperties[key] = value;
            }
        }
        return finalConfig;
    }, {});
    return Object.values(mergedConfigurations);
}
exports.combineConfigurations = combineConfigurations;
//# sourceMappingURL=data:application/json;base64,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