import { Table } from "aws-cdk-lib/aws-dynamodb";
import { IGrantable } from "aws-cdk-lib/aws-iam";
import { RemovalPolicy } from "aws-cdk-lib/core";
import { Construct } from "constructs";
export interface NessieVersionStoreProps {
    /**
     * Nessie has two tables, `objs` and `refs`.
     *
     * Nessie supports configuring a "prefix" that will be used to determine the names of these tables.
     *
     * @default - "nessie"
     * @see https://project-nessie.zulipchat.com/#narrow/stream/371187-general/topic/AWS.20Lambda.20with.20SnapStart/near/420329834
     */
    readonly versionStoreName?: string;
    /**
     * @default - RemovalPolicy.DESTROY
     */
    readonly removalPolicy?: RemovalPolicy;
}
/**
 * @see https://projectnessie.org/try/configuration/#dynamodb-version-store-settings
 */
export declare class DynamoDBNessieVersionStore extends Construct {
    readonly refs: Table;
    readonly objs: Table;
    readonly tablePrefix: string;
    constructor(scope: Construct, id: string, props?: NessieVersionStoreProps);
    grantReadData(grantee: IGrantable): void;
    grantWriteData(grantee: IGrantable): void;
    grantReadWriteData(grantee: IGrantable): void;
}
