import type { ICatalog } from "./catalog.js";
import type { Cluster } from "./cluster.js";
import { IBucket } from "aws-cdk-lib/aws-s3";
import { Construct } from "constructs";
export interface IcebergGlueCatalogProps {
    /**
     * The S3 bucket where the Iceberg table data is stored.
     *
     * @default - one is created for you
     */
    readonly warehouseBucket?: IBucket;
    /**
     * The prefix for the Iceberg table data in the S3 bucket.
     *
     * @default - no prefix (e.g. use the root: `s3://bucket/`)
     */
    readonly warehousePrefix?: string;
}
export interface FromBucketProps {
    readonly warehouseBucketName: string;
    readonly warehousePrefix?: string;
}
export declare class IcebergGlueCatalog extends Construct implements ICatalog {
    private readonly warehouseBucket;
    private readonly warehousePrefix;
    static fromBucketName(scope: Construct, id: string, props: FromBucketProps): IcebergGlueCatalog;
    constructor(scope: Construct, id: string, props: IcebergGlueCatalogProps);
    bind(cluster: Cluster, catalogName: string): void;
}
